"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetricSelector = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _agg_select = require("../agg_select");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MAX_WIDTH = 560;
const MetricSelector = ({
  fields,
  detectorChangeHandler,
  selectedOptions,
  maxWidth,
  removeOptions
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    style: {
      maxWidth: maxWidth !== undefined ? maxWidth : MAX_WIDTH
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.ml.newJob.wizard.pickFieldsStep.metricSelector.addMetric', {
      defaultMessage: 'Add metric'
    })
  }, /*#__PURE__*/_react.default.createElement(_agg_select.AggSelect, {
    fields: fields,
    changeHandler: detectorChangeHandler,
    selectedOptions: selectedOptions,
    removeOptions: removeOptions
  }))));
};
exports.MetricSelector = MetricSelector;