"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DetectorDescriptionList = DetectorDescriptionList;
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _anomaly_value_display = require("../../../anomalies_table/anomaly_value_display");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * React component for listing pairs of information about the detector for which
 * rules are being edited.
 */

function DetectorDescriptionList({
  job,
  detector,
  anomaly
}) {
  const listItems = [{
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.ruleEditor.detectorDescriptionList.jobIdTitle",
      defaultMessage: "Job ID"
    }),
    description: job.job_id
  }, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.ruleEditor.detectorDescriptionList.detectorTitle",
      defaultMessage: "Detector"
    }),
    description: detector.detector_description
  }];
  if (anomaly.actual !== undefined) {
    // Format based on magnitude of value at this stage, rather than using the
    // Kibana field formatter (if set) which would add complexity converting
    // the entered value to / from e.g. bytes.

    listItems.push({
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.ruleEditor.detectorDescriptionList.selectedAnomalyTitle",
        defaultMessage: "Selected anomaly"
      }),
      description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.ruleEditor.detectorDescriptionList.selectedAnomalyDescription",
        defaultMessage: "actual {actual}, typical {typical}",
        values: {
          actual: /*#__PURE__*/_react.default.createElement(_anomaly_value_display.AnomalyValueDisplay, {
            value: anomaly.actual,
            function: anomaly.source.function,
            record: anomaly
          }),
          typical: /*#__PURE__*/_react.default.createElement(_anomaly_value_display.AnomalyValueDisplay, {
            value: anomaly.typical,
            function: anomaly.source.function,
            record: anomaly
          })
        }
      })
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    type: "column",
    columnWidths: [15, 85],
    listItems: listItems
  });
}
DetectorDescriptionList.propTypes = {
  job: _propTypes.default.object.isRequired,
  detector: _propTypes.default.object.isRequired,
  anomaly: _propTypes.default.object.isRequired
};