"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useLogSummaryHighlights = void 0;
var _react = require("react");
var _lodash = require("lodash");
var _use_tracked_promise = require("../../../utils/use_tracked_promise");
var _fetch_log_summary_highlights = require("./api/fetch_log_summary_highlights");
var _bucket_size = require("../log_summary/bucket_size");
var _use_kibana = require("../../../hooks/use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useLogSummaryHighlights = (logViewReference, sourceVersion, startTimestamp, endTimestamp, filterQuery, highlightTerms) => {
  const {
    services
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const [logSummaryHighlights, setLogSummaryHighlights] = (0, _react.useState)([]);
  const bucketSize = (0, _bucket_size.useBucketSize)(startTimestamp, endTimestamp);
  const [loadLogSummaryHighlightsRequest, loadLogSummaryHighlights] = (0, _use_tracked_promise.useTrackedPromise)({
    cancelPreviousOn: 'resolution',
    createPromise: async () => {
      if (!startTimestamp || !endTimestamp || !bucketSize || !highlightTerms.length) {
        throw new Error('Skipping request: Insufficient parameters');
      }
      return await (0, _fetch_log_summary_highlights.fetchLogSummaryHighlights)({
        logView: logViewReference,
        startTimestamp,
        endTimestamp,
        bucketSize,
        query: filterQuery,
        highlightTerms
      }, services.http.fetch);
    },
    onResolve: response => {
      setLogSummaryHighlights(response.data);
    }
  }, [logViewReference, startTimestamp, endTimestamp, bucketSize, filterQuery, highlightTerms]);
  const debouncedLoadSummaryHighlights = (0, _react.useMemo)(() => (0, _lodash.debounce)(loadLogSummaryHighlights, 275), [loadLogSummaryHighlights]);
  (0, _react.useEffect)(() => {
    setLogSummaryHighlights([]);
  }, [highlightTerms]);
  (0, _react.useEffect)(() => {
    if (highlightTerms.filter(highlightTerm => highlightTerm.length > 0).length && startTimestamp && endTimestamp) {
      debouncedLoadSummaryHighlights();
    } else {
      setLogSummaryHighlights([]);
    }
  }, [bucketSize, debouncedLoadSummaryHighlights, filterQuery, highlightTerms, sourceVersion, startTimestamp, endTimestamp]);
  return {
    logSummaryHighlights,
    loadLogSummaryHighlightsRequest
  };
};
exports.useLogSummaryHighlights = useLogSummaryHighlights;