"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CreateIntegrationLanding = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _sharedUxPageKibanaTemplate = require("@kbn/shared-ux-page-kibana-template");
var _i18nReact = require("@kbn/i18n-react");
var _authorization = require("../../../common/components/authorization");
var _availability_wrapper = require("../../../common/components/availability_wrapper");
var _integration_image_header = require("../../../common/components/integration_image_header");
var _buttons_footer = require("../../../common/components/buttons_footer");
var _section_wrapper = require("../../../common/components/section_wrapper");
var _use_navigate = require("../../../common/hooks/use_navigate");
var _integration_assistant_card = require("./integration_assistant_card");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CreateIntegrationLanding = exports.CreateIntegrationLanding = /*#__PURE__*/_react.default.memo(() => {
  const navigate = (0, _use_navigate.useNavigate)();
  return /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate, null, /*#__PURE__*/_react.default.createElement(_integration_image_header.IntegrationImageHeader, null), /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate.Section, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_section_wrapper.SectionWrapper, {
    title: i18n.LANDING_TITLE,
    subtitle: i18n.LANDING_DESCRIPTION
  }, /*#__PURE__*/_react.default.createElement(_availability_wrapper.AvailabilityWrapper, null, /*#__PURE__*/_react.default.createElement(_authorization.AuthorizationWrapper, {
    canCreateIntegrations: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "l",
    alignItems: "center",
    justifyContent: "flexStart"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_integration_assistant_card.IntegrationAssistantCard, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "s",
    alignItems: "center",
    justifyContent: "flexStart"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "package",
    size: "l"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.integrationAssistant.createIntegrationLanding.uploadPackageDescription",
    defaultMessage: "If you have an existing integration package, {link}",
    values: {
      link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        onClick: () => navigate(_use_navigate.Page.upload),
        "data-test-subj": "uploadPackageLink"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.integrationAssistant.createIntegrationLanding.uploadPackageLink",
        defaultMessage: "upload it as a .zip"
      }))
    }
  })))))))))), /*#__PURE__*/_react.default.createElement(_buttons_footer.ButtonsFooter, null));
});
CreateIntegrationLanding.displayName = 'CreateIntegrationLanding';