"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GrokDebuggerUIPlugin = void 0;
var _i18n = require("@kbn/i18n");
var _rxjs = require("rxjs");
var _constants = require("../common/constants");
var _register_feature = require("./register_feature");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
class GrokDebuggerUIPlugin {
  setup(coreSetup, plugins) {
    (0, _register_feature.registerFeature)(plugins.home);
    const devTool = plugins.devTools.register({
      order: 6,
      title: _i18n.i18n.translate('xpack.grokDebugger.displayName', {
        defaultMessage: 'Grok Debugger'
      }),
      id: _constants.PLUGIN.ID,
      enableRouting: false,
      async mount({
        element,
        theme$
      }) {
        const [coreStart] = await coreSetup.getStartServices();
        const license = await (0, _rxjs.firstValueFrom)(plugins.licensing.license$);
        const {
          renderApp
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./render_app')));
        return renderApp(license, element, coreStart, theme$);
      }
    });
    plugins.licensing.license$.subscribe(license => {
      if (!license.isActive && !devTool.isDisabled()) {
        devTool.disable();
      } else if (devTool.isDisabled()) {
        devTool.enable();
      }
    });
  }
  start() {}
  stop() {}
}
exports.GrokDebuggerUIPlugin = GrokDebuggerUIPlugin;