"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.datasourceSaga = void 0;
var _effects = require("redux-saga/effects");
var _i18n = require("@kbn/i18n");
var _fields = require("./fields");
var _persistence = require("../services/persistence");
var _advanced_settings = require("./advanced_settings");
var _datasource = require("./datasource");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Saga loading field information when the datasource is switched. This will overwrite current settings
 * in fields.
 *
 * TODO: Carry over fields than can be carried over because they also exist in the target index pattern
 */
const datasourceSaga = ({
  indexPatternProvider,
  notifications,
  createWorkspace,
  notifyReact
}) => {
  function* fetchFields(action) {
    try {
      const indexPattern = yield (0, _effects.call)(indexPatternProvider.get, action.payload.id);
      yield (0, _effects.put)((0, _fields.loadFields)((0, _persistence.mapFields)(indexPattern)));
      yield (0, _effects.put)((0, _datasource.datasourceLoaded)());
      const advancedSettings = (0, _advanced_settings.settingsSelector)(yield (0, _effects.select)());
      createWorkspace(indexPattern.title, advancedSettings);
      notifyReact();
    } catch (e) {
      // in case of errors, reset the datasource and show notification
      yield (0, _effects.put)((0, _datasource.setDatasource)({
        type: 'none'
      }));
      notifications.toasts.addDanger(_i18n.i18n.translate('xpack.graph.loadWorkspace.missingDataViewErrorMessage', {
        defaultMessage: 'Data view "{name}" not found',
        values: {
          name: action.payload.title
        }
      }));
    }
  }
  return function* () {
    yield (0, _effects.takeLatest)(_datasource.requestDatasource.match, fetchFields);
  };
};
exports.datasourceSaga = datasourceSaga;