"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.URL_LABEL = exports.UPDATE_LABEL = exports.UPDATE_BUTTON = exports.STATUS_POPOVER_TOOLTIP = exports.STANDARD_SOURCES_TOGGLE_TEXT = exports.STANDARD_SOURCES_TABLE_DESCRIPTION = exports.STANDARD_SOURCES_EMPTY_TABLE_TITLE = exports.SOURCE_STATUSES = exports.SOURCE_RESTRICTIONS_SUCCESS_MESSAGE = exports.SOURCE_OBJ_TYPES = exports.SOURCE_NAMES = exports.SOURCE_CATEGORIES = exports.SOURCE = exports.SECURITY_UNSAVED_CHANGES_MESSAGE = exports.SEARCHABLE_HEADER = exports.SAVE_SETTINGS_BUTTON = exports.SAVE_CHANGES_BUTTON = exports.SAVE_BUTTON = exports.RESET_BUTTON = exports.REMOVE_FIELD_LABEL = exports.REMOVE_BUTTON = exports.REMOTE_SOURCES_TOGGLE_TEXT = exports.REMOTE_SOURCES_TABLE_DESCRIPTION = exports.REMOTE_SOURCES_EMPTY_TABLE_TITLE = exports.REDIRECT_URIS_LABEL = exports.REDIRECT_SECURE_ERROR_TEXT = exports.REDIRECT_NATIVE_HELP_TEXT = exports.REDIRECT_INSECURE_ERROR_TEXT = exports.REDIRECT_HELP_TEXT = exports.RECENT_ACTIVITY_TITLE = exports.PUBLIC_KEY_LABEL = exports.PRIVATE_VIEW_ONLY_PAGE_TITLE = exports.PRIVATE_VIEW_ONLY_PAGE_DESCRIPTION = exports.PRIVATE_SOURCES_UPDATE_CONFIRMATION_TEXT = exports.PRIVATE_SOURCES_TOGGLE_DESCRIPTION = exports.PRIVATE_SOURCES_DESCRIPTION = exports.PRIVATE_SOURCES = exports.PRIVATE_SOURCE = exports.PRIVATE_PLATINUM_LICENSE_CALLOUT = exports.PRIVATE_CAN_CREATE_PAGE_TITLE = exports.PRIVATE_CAN_CREATE_PAGE_DESCRIPTION = exports.PLATINUM_FEATURE = exports.ORG_UPDATED_MESSAGE = exports.ON_LABEL = exports.OK_BUTTON = exports.OAUTH_PERSISTED_DESCRIPTION = exports.OAUTH_DESCRIPTION = exports.OAUTH_APP_UPDATED_MESSAGE = exports.NON_PLATINUM_OAUTH_TITLE = exports.NON_PLATINUM_OAUTH_DESCRIPTION = exports.NAV = exports.NAME_LABEL = exports.MAX_TABLE_ROW_ICONS = exports.LABEL_LABEL = exports.KEEP_EDITING_BUTTON = exports.GITHUB_VIA_APP_SERVICE_TYPE = exports.GITHUB_LINK_TITLE = exports.GITHUB_ENTERPRISE_SERVER_VIA_APP_SERVICE_TYPE = exports.FIELD_LABEL = exports.EXTERNAL_SERVICE_TYPE = exports.EXTERNAL_CONNECTOR_URL_LABEL = exports.EXTERNAL_CONNECTOR_API_KEY_LABEL = exports.EXPLORE_PLATINUM_FEATURES_LINK = exports.EDIT_FIELD_LABEL = exports.DOCUMENTS_HEADER = exports.DOCUMENTATION_LINK_TITLE = exports.DESCRIPTION_LABEL = exports.CUSTOM_SERVICE_TYPE = exports.CUSTOMIZE_NAME_LABEL = exports.CUSTOMIZE_NAME_BUTTON = exports.CUSTOMIZE_HEADER_TITLE = exports.CUSTOMIZE_HEADER_DESCRIPTION = exports.CREDENTIALS_TITLE = exports.CREDENTIALS_DESCRIPTION = exports.COPY_TOOLTIP = exports.COPY_TEXT = exports.COPIED_TOOLTIP = exports.CONSUMER_KEY_LABEL = exports.CONNECTORS_HEADER_TITLE = exports.CONNECTORS_HEADER_DESCRIPTION = exports.CONFIRM_MODAL_TITLE = exports.CONFIRM_CHANGES_TEXT = exports.CONFIGURE_BUTTON = exports.CONFIDENTIAL_LABEL = exports.CONFIDENTIAL_HELP_TEXT = exports.CLIENT_SECRET_LABEL = exports.CLIENT_ID_LABEL = exports.CANCEL_BUTTON = exports.BLOCK_LABEL = exports.BETWEEN_LABEL = exports.BASE_URL_LABEL = exports.BASE_URI_LABEL = exports.API_KEY_LABEL = exports.API_KEYS_TITLE = exports.AND = exports.ADD_LABEL = exports.ADD_FIELD_LABEL = exports.ACCOUNT_SETTINGS_TITLE = exports.ACCOUNT_SETTINGS_DESCRIPTION = exports.ACCOUNT_NAV = void 0;
exports.WORKPLACE_SEARCH_TITLE = void 0;
var _i18n = require("@kbn/i18n");
var _constants = require("../shared/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const WORKPLACE_SEARCH_TITLE = exports.WORKPLACE_SEARCH_TITLE = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.title', {
  defaultMessage: 'Workplace Search'
});
const NAV = exports.NAV = {
  OVERVIEW: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.nav.overview', {
    defaultMessage: 'Overview'
  }),
  SOURCES: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.nav.sources', {
    defaultMessage: 'Sources'
  }),
  GROUPS: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.nav.groups', {
    defaultMessage: 'Groups'
  }),
  GROUP_OVERVIEW: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.nav.groups.groupOverview', {
    defaultMessage: 'Overview'
  }),
  SOURCE_PRIORITIZATION: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.nav.groups.sourcePrioritization', {
    defaultMessage: 'Source Prioritization'
  }),
  CONTENT: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.nav.content', {
    defaultMessage: 'Content'
  }),
  ROLE_MAPPINGS: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.nav.roleMappings', {
    defaultMessage: 'Users and roles'
  }),
  API_KEYS: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.nav.apiKeys', {
    defaultMessage: 'API keys'
  }),
  SECURITY: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.nav.security', {
    defaultMessage: 'Security'
  }),
  SCHEMA: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.nav.schema', {
    defaultMessage: 'Schema'
  }),
  SYNCHRONIZATION: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.nav.synchronization', {
    defaultMessage: 'Synchronization'
  }),
  SYNCHRONIZATION_FREQUENCY: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.nav.synchronizationFrequency', {
    defaultMessage: 'Frequency'
  }),
  SYNCHRONIZATION_ASSETS_AND_OBJECTS: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.nav.synchronizationAssetsAndObjects', {
    defaultMessage: 'Assets and objects'
  }),
  DISPLAY_SETTINGS: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.nav.displaySettings', {
    defaultMessage: 'Display Settings'
  }),
  SETTINGS: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.nav.settings', {
    defaultMessage: 'Settings'
  }),
  SETTINGS_CUSTOMIZE: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.nav.settingsCustomize', {
    defaultMessage: 'Customize'
  }),
  SETTINGS_SOURCE_PRIORITIZATION: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.nav.settingsSourcePrioritization', {
    defaultMessage: 'Content source connectors'
  }),
  SETTINGS_OAUTH: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.nav.settingsOauth', {
    defaultMessage: 'OAuth application'
  }),
  ADD_SOURCE: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.nav.addSource', {
    defaultMessage: 'Add Source'
  }),
  PERSONAL_DASHBOARD: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.nav.personalDashboard', {
    defaultMessage: 'View my personal dashboard'
  }),
  SEARCH: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.nav.searchApplication', {
    defaultMessage: 'Go to search application'
  })
};
const ACCOUNT_NAV = exports.ACCOUNT_NAV = {
  SOURCES: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.accountNav.sources.link', {
    defaultMessage: 'Content sources'
  }),
  ORG_DASHBOARD: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.accountNav.orgDashboard.link', {
    defaultMessage: 'Go to organizational dashboard'
  }),
  SEARCH: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.accountNav.search.link', {
    defaultMessage: 'Search'
  }),
  ACCOUNT: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.accountNav.account.link', {
    defaultMessage: 'My account'
  }),
  SETTINGS: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.accountNav.settings.link', {
    defaultMessage: 'Account settings'
  }),
  LOGOUT: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.accountNav.logout.link', {
    defaultMessage: 'Logout'
  })
};
const MAX_TABLE_ROW_ICONS = exports.MAX_TABLE_ROW_ICONS = 3;
const SOURCE_STATUSES = exports.SOURCE_STATUSES = {
  INDEXING: 'indexing',
  SYNCED: 'synced',
  SYNCING: 'syncing',
  AWAITING_USER_ACTION: 'awaiting_user_action',
  ERROR: 'error',
  DISCONNECTED: 'disconnected',
  ALWAYS_SYNCED: 'always_synced'
};
const SOURCE_NAMES = exports.SOURCE_NAMES = {
  BOX: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.sourceNames.box', {
    defaultMessage: 'Box'
  }),
  CONFLUENCE: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.sourceNames.confluence', {
    defaultMessage: 'Confluence'
  }),
  CONFLUENCE_CONNECTOR_PACKAGE: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.sourceNames.confluenceConnectorPackage', {
    defaultMessage: 'Confluence Connector Package'
  }),
  CONFLUENCE_SERVER: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.sourceNames.confluenceServer', {
    defaultMessage: 'Confluence (Server)'
  }),
  DROPBOX: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.sourceNames.dropbox', {
    defaultMessage: 'Dropbox'
  }),
  GITHUB: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.sourceNames.github', {
    defaultMessage: 'GitHub'
  }),
  GITHUB_ENTERPRISE: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.sourceNames.githubEnterprise', {
    defaultMessage: 'GitHub Enterprise Server'
  }),
  GMAIL: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.sourceNames.gmail', {
    defaultMessage: 'Gmail'
  }),
  GOOGLE_DRIVE: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.sourceNames.googleDrive', {
    defaultMessage: 'Google Drive'
  }),
  JIRA: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.sourceNames.jira', {
    defaultMessage: 'Jira'
  }),
  JIRA_SERVER: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.sourceNames.jiraServer', {
    defaultMessage: 'Jira (Server)'
  }),
  NETWORK_DRVE: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.sourceNames.networkDrive', {
    defaultMessage: 'Network Drive'
  }),
  ONEDRIVE: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.sourceNames.oneDrive', {
    defaultMessage: 'OneDrive'
  }),
  OUTLOOK: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.sourceNames.outlook', {
    defaultMessage: 'Outlook'
  }),
  SALESFORCE: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.sourceNames.salesforce', {
    defaultMessage: 'Salesforce'
  }),
  SALESFORCE_SANDBOX: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.sourceNames.salesforceSandbox', {
    defaultMessage: 'Salesforce Sandbox'
  }),
  SERVICENOW: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.sourceNames.serviceNow', {
    defaultMessage: 'ServiceNow'
  }),
  SHAREPOINT: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.sourceNames.sharePoint', {
    defaultMessage: 'SharePoint Online'
  }),
  SHAREPOINT_CONNECTOR_PACKAGE: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.sourceNames.sharePointConnectorPackage', {
    defaultMessage: 'SharePoint Online Connector Package'
  }),
  SHAREPOINT_SERVER: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.sourceNames.sharePointServer', {
    defaultMessage: 'SharePoint Server'
  }),
  SLACK: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.sourceNames.slack', {
    defaultMessage: 'Slack'
  }),
  TEAMS: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.sourceNames.teams', {
    defaultMessage: 'Teams'
  }),
  ZENDESK: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.sourceNames.zendesk', {
    defaultMessage: 'Zendesk'
  }),
  ZOOM: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.sourceNames.zoom', {
    defaultMessage: 'Zoom'
  }),
  CUSTOM: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.sourceNames.custom', {
    defaultMessage: 'Custom API Source'
  }),
  CUSTOM_CONNECTOR_PACKAGE: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.sourceNames.customConnectorPackage', {
    defaultMessage: 'Custom Connector Package'
  })
};
const SOURCE_OBJ_TYPES = exports.SOURCE_OBJ_TYPES = {
  FOLDERS: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.objTypes.folders', {
    defaultMessage: 'Folders'
  }),
  PAGES: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.objTypes.pages', {
    defaultMessage: 'Pages'
  }),
  ATTACHMENTS: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.objTypes.attachments', {
    defaultMessage: 'Attachments'
  }),
  BLOG_POSTS: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.objTypes.blogPosts', {
    defaultMessage: 'Blog Posts'
  }),
  SITES: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.objTypes.sites', {
    defaultMessage: 'Sites'
  }),
  SPACES: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.objTypes.spaces', {
    defaultMessage: 'Spaces'
  }),
  ALL_FILES: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.objTypes.allFiles', {
    defaultMessage: 'All Files (including images, PDFs, spreadsheets, textual documents, presentations)'
  }),
  ALL_STORED_FILES: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.objTypes.allStoredFiles', {
    defaultMessage: 'All Stored Files (including images, videos, PDFs, spreadsheets, textual documents, presentations)'
  }),
  G_SUITE_FILES: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.objTypes.gSuiteFiles', {
    defaultMessage: 'Google G Suite Documents (Docs, Sheets, Slides)'
  }),
  EPICS: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.objTypes.epics', {
    defaultMessage: 'Epics'
  }),
  PROJECTS: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.objTypes.projects', {
    defaultMessage: 'Projects'
  }),
  TASKS: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.objTypes.tasks', {
    defaultMessage: 'Tasks'
  }),
  STORIES: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.objTypes.stories', {
    defaultMessage: 'Stories'
  }),
  BUGS: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.objTypes.bugs', {
    defaultMessage: 'Bugs'
  }),
  ISSUES: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.objTypes.issues', {
    defaultMessage: 'Issues (including comments)'
  }),
  PULL_REQUESTS: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.objTypes.pullRequests', {
    defaultMessage: 'Pull Requests (including comments)'
  }),
  REPOSITORY_LIST: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.objTypes.repositoryList', {
    defaultMessage: 'Repository List'
  }),
  FILES: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.objTypes.files', {
    defaultMessage: 'Files (markdown only)'
  }),
  EMAILS: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.objTypes.emails', {
    defaultMessage: 'Emails'
  }),
  CONTACTS: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.objTypes.contacts', {
    defaultMessage: 'Contacts'
  }),
  OPPORTUNITIES: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.objTypes.opportunities', {
    defaultMessage: 'Opportunities'
  }),
  LEADS: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.objTypes.leads', {
    defaultMessage: 'Leads'
  }),
  ACCOUNTS: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.objTypes.accounts', {
    defaultMessage: 'Accounts'
  }),
  CAMPAIGNS: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.objTypes.campaigns', {
    defaultMessage: 'Campaigns'
  }),
  CASES: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.objTypes.cases', {
    defaultMessage: 'Cases (including feeds and comments)'
  }),
  USERS: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.objTypes.users', {
    defaultMessage: 'Users'
  }),
  INCIDENTS: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.objTypes.incidents', {
    defaultMessage: 'Incidents'
  }),
  ITEMS: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.objTypes.items', {
    defaultMessage: 'Items'
  }),
  ARTICLES: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.objTypes.articles', {
    defaultMessage: 'Articles'
  }),
  TICKETS: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.objTypes.tickets', {
    defaultMessage: 'Tickets'
  }),
  PUBLIC_MESSAGES: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.objTypes.publicMessages', {
    defaultMessage: 'Public channel messages'
  }),
  PRIVATE_MESSAGES: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.objTypes.privateMessages', {
    defaultMessage: 'Private channel messages in which you are an active participant'
  }),
  DIRECT_MESSAGES: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.objTypes.directMessages', {
    defaultMessage: 'Direct messages'
  })
};
const SOURCE_CATEGORIES = exports.SOURCE_CATEGORIES = {
  ACCOUNT_MANAGEMENT: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.categories.accountManagement', {
    defaultMessage: 'Account management'
  }),
  ATLASSIAN: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.categories.atlassian', {
    defaultMessage: 'Atlassian'
  }),
  BUG_TRACKING: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.categories.bugTracking', {
    defaultMessage: 'Bug tracking'
  }),
  CHAT: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.categories.chat', {
    defaultMessage: 'Chat'
  }),
  CLOUD: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.categories.cloud', {
    defaultMessage: 'Cloud'
  }),
  CODE_REPOSITORY: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.categories.codeRepository', {
    defaultMessage: 'Code repository'
  }),
  COLLABORATION: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.categories.collaboration', {
    defaultMessage: 'Collaboration'
  }),
  COMMUNICATION: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.categories.communication', {
    defaultMessage: 'Communication'
  }),
  CRM: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.categories.crm', {
    defaultMessage: 'CRM'
  }),
  CUSTOMER_RELATIONSHIP_MANAGEMENT: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.categories.customerRelationshipManagement', {
    defaultMessage: 'Customer relationship management'
  }),
  CUSTOMER_SERVICE: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.categories.customerService', {
    defaultMessage: 'Customer service'
  }),
  EMAIL: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.categories.email', {
    defaultMessage: 'Email'
  }),
  FILE_SHARING: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.categories.fileSharing', {
    defaultMessage: 'File sharing'
  }),
  GOOGLE: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.categories.google', {
    defaultMessage: 'Google'
  }),
  GSUITE: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.categories.gsuite', {
    defaultMessage: 'GSuite'
  }),
  HELP: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.categories.help', {
    defaultMessage: 'Help'
  }),
  HELPDESK: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.categories.helpdesk', {
    defaultMessage: 'Helpdesk'
  }),
  INSTANT_MESSAGING: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.categories.instantMessaging', {
    defaultMessage: 'Instant messaging'
  }),
  INTRANET: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.categories.intranet', {
    defaultMessage: 'Intranet'
  }),
  MICROSOFT: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.categories.microsoft', {
    defaultMessage: 'Microsoft'
  }),
  OFFICE_365: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.categories.office', {
    defaultMessage: 'Office 365'
  }),
  PRODUCTIVITY: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.categories.productivity', {
    defaultMessage: 'Productivity'
  }),
  PROJECT_MANAGEMENT: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.categories.projectManagement', {
    defaultMessage: 'Project management'
  }),
  SOFTWARE: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.categories.software', {
    defaultMessage: 'Software'
  }),
  STORAGE: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.categories.storage', {
    defaultMessage: 'Storage'
  }),
  TICKETING: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.categories.ticketing', {
    defaultMessage: 'Ticketing'
  }),
  VERSION_CONTROL: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.categories.versionControl', {
    defaultMessage: 'Version control'
  }),
  WIKI: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.categories.wiki', {
    defaultMessage: 'Wiki'
  }),
  WORKFLOW: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.categories.workflow', {
    defaultMessage: 'Workflow'
  })
};
const API_KEYS_TITLE = exports.API_KEYS_TITLE = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.apiKeysTitle', {
  defaultMessage: 'API keys'
});
const API_KEY_LABEL = exports.API_KEY_LABEL = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.apiKeyLabel', {
  defaultMessage: 'API key'
});
const GITHUB_LINK_TITLE = exports.GITHUB_LINK_TITLE = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.applicationLinkTitles.github', {
  defaultMessage: 'GitHub Developer Portal'
});
const GITHUB_VIA_APP_SERVICE_TYPE = exports.GITHUB_VIA_APP_SERVICE_TYPE = 'github_via_app';
const GITHUB_ENTERPRISE_SERVER_VIA_APP_SERVICE_TYPE = exports.GITHUB_ENTERPRISE_SERVER_VIA_APP_SERVICE_TYPE = 'github_enterprise_server_via_app';
const CUSTOM_SERVICE_TYPE = exports.CUSTOM_SERVICE_TYPE = 'custom';
const EXTERNAL_SERVICE_TYPE = exports.EXTERNAL_SERVICE_TYPE = 'external';
const DOCUMENTATION_LINK_TITLE = exports.DOCUMENTATION_LINK_TITLE = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.documentation', {
  defaultMessage: 'Documentation'
});
const PRIVATE_SOURCES_DESCRIPTION = exports.PRIVATE_SOURCES_DESCRIPTION = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.security.privateSources.description', {
  defaultMessage: 'Private sources are connected by users in your organization to create a personalized search experience.'
});
const PRIVATE_SOURCES_TOGGLE_DESCRIPTION = exports.PRIVATE_SOURCES_TOGGLE_DESCRIPTION = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.security.privateSourcesToggle.description', {
  defaultMessage: 'Enable private sources for your organization'
});
const REMOTE_SOURCES_TOGGLE_TEXT = exports.REMOTE_SOURCES_TOGGLE_TEXT = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.security.remoteSourcesToggle.text', {
  defaultMessage: 'Enable remote private sources'
});
const REMOTE_SOURCES_TABLE_DESCRIPTION = exports.REMOTE_SOURCES_TABLE_DESCRIPTION = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.security.remoteSourcesTable.description', {
  defaultMessage: 'Remote sources synchronize and store a limited amount of data on disk, with a low impact on storage resources.'
});
const REMOTE_SOURCES_EMPTY_TABLE_TITLE = exports.REMOTE_SOURCES_EMPTY_TABLE_TITLE = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.security.remoteSourcesEmptyTable.title', {
  defaultMessage: 'No remote private sources configured yet'
});
const STANDARD_SOURCES_TOGGLE_TEXT = exports.STANDARD_SOURCES_TOGGLE_TEXT = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.security.standardSourcesToggle.text', {
  defaultMessage: 'Enable standard private sources'
});
const STANDARD_SOURCES_TABLE_DESCRIPTION = exports.STANDARD_SOURCES_TABLE_DESCRIPTION = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.security.standardSourcesTable.description', {
  defaultMessage: 'Standard sources synchronize and store all searchable data on disk, with a directly correlated impact on storage resources.'
});
const STANDARD_SOURCES_EMPTY_TABLE_TITLE = exports.STANDARD_SOURCES_EMPTY_TABLE_TITLE = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.security.standardSourcesEmptyTable.title', {
  defaultMessage: 'No standard private sources configured yet'
});
const SECURITY_UNSAVED_CHANGES_MESSAGE = exports.SECURITY_UNSAVED_CHANGES_MESSAGE = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.security.unsavedChanges.message', {
  defaultMessage: 'Your private sources settings have not been saved. Are you sure you want to leave?'
});
const PRIVATE_SOURCES_UPDATE_CONFIRMATION_TEXT = exports.PRIVATE_SOURCES_UPDATE_CONFIRMATION_TEXT = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.security.privateSourcesUpdateConfirmation.text', {
  defaultMessage: 'Updates to private source configuration will take effect immediately.'
});
const SOURCE_RESTRICTIONS_SUCCESS_MESSAGE = exports.SOURCE_RESTRICTIONS_SUCCESS_MESSAGE = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.security.sourceRestrictionsSuccess.message', {
  defaultMessage: 'Successfully updated source restrictions.'
});
const PUBLIC_KEY_LABEL = exports.PUBLIC_KEY_LABEL = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.publicKey.label', {
  defaultMessage: 'Public Key'
});
const CONSUMER_KEY_LABEL = exports.CONSUMER_KEY_LABEL = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.consumerKey.label', {
  defaultMessage: 'Consumer Key'
});
const BASE_URI_LABEL = exports.BASE_URI_LABEL = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.baseUri.label', {
  defaultMessage: 'Base URI'
});
const BASE_URL_LABEL = exports.BASE_URL_LABEL = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.baseUrl.label', {
  defaultMessage: 'Base URL'
});
const EXTERNAL_CONNECTOR_URL_LABEL = exports.EXTERNAL_CONNECTOR_URL_LABEL = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.externalConnectorUrl.label', {
  defaultMessage: 'Connector URL'
});
const EXTERNAL_CONNECTOR_API_KEY_LABEL = exports.EXTERNAL_CONNECTOR_API_KEY_LABEL = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.externalConnectorApiKey.label', {
  defaultMessage: 'Connector API key'
});
const CLIENT_ID_LABEL = exports.CLIENT_ID_LABEL = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.clientId.label', {
  defaultMessage: 'Client id'
});
const CLIENT_SECRET_LABEL = exports.CLIENT_SECRET_LABEL = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.clientSecret.label', {
  defaultMessage: 'Client secret'
});
const CONFIDENTIAL_LABEL = exports.CONFIDENTIAL_LABEL = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.confidential.label', {
  defaultMessage: 'Confidential'
});
const CONFIDENTIAL_HELP_TEXT = exports.CONFIDENTIAL_HELP_TEXT = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.confidential.text', {
  defaultMessage: 'Deselect for environments in which the client secret cannot be kept confidential, such as native mobile apps and single page applications.'
});
const CREDENTIALS_TITLE = exports.CREDENTIALS_TITLE = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.credentials.title', {
  defaultMessage: 'Credentials'
});
const CREDENTIALS_DESCRIPTION = exports.CREDENTIALS_DESCRIPTION = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.credentials.description', {
  defaultMessage: 'Use the following credentials within your client to request access tokens from our authentication server.'
});
const ORG_UPDATED_MESSAGE = exports.ORG_UPDATED_MESSAGE = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.settings.orgUpdated.message', {
  defaultMessage: 'Successfully updated organization.'
});
const OAUTH_APP_UPDATED_MESSAGE = exports.OAUTH_APP_UPDATED_MESSAGE = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.settings.oauthAppUpdated.message', {
  defaultMessage: 'Successfully updated application.'
});
const SAVE_CHANGES_BUTTON = exports.SAVE_CHANGES_BUTTON = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.saveChanges.button', {
  defaultMessage: 'Save changes'
});
const SAVE_SETTINGS_BUTTON = exports.SAVE_SETTINGS_BUTTON = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.saveSettings.button', {
  defaultMessage: 'Save settings'
});
const KEEP_EDITING_BUTTON = exports.KEEP_EDITING_BUTTON = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.keepEditing.button', {
  defaultMessage: 'Keep editing'
});
const NAME_LABEL = exports.NAME_LABEL = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.name.label', {
  defaultMessage: 'Name'
});
const OAUTH_DESCRIPTION = exports.OAUTH_DESCRIPTION = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.oauth.description', {
  defaultMessage: 'Create an OAuth client for your organization.'
});
const OAUTH_PERSISTED_DESCRIPTION = exports.OAUTH_PERSISTED_DESCRIPTION = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.oauthPersisted.description', {
  defaultMessage: "Access your organization's OAuth client credentials and manage OAuth settings."
});
const REDIRECT_URIS_LABEL = exports.REDIRECT_URIS_LABEL = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.redirectURIs.label', {
  defaultMessage: 'Redirect URIs'
});
const REDIRECT_HELP_TEXT = exports.REDIRECT_HELP_TEXT = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.redirectHelp.text', {
  defaultMessage: 'Provide one URI per line.'
});
const REDIRECT_NATIVE_HELP_TEXT = exports.REDIRECT_NATIVE_HELP_TEXT = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.redirectNativeHelp.text', {
  defaultMessage: 'For local development URIs, use format'
});
const REDIRECT_SECURE_ERROR_TEXT = exports.REDIRECT_SECURE_ERROR_TEXT = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.redirectSecureError.text', {
  defaultMessage: 'Cannot contain duplicate redirect URIs.'
});
const REDIRECT_INSECURE_ERROR_TEXT = exports.REDIRECT_INSECURE_ERROR_TEXT = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.redirectInsecureError.text', {
  defaultMessage: 'Using an insecure redirect URI (http) is not recommended.'
});
const NON_PLATINUM_OAUTH_TITLE = exports.NON_PLATINUM_OAUTH_TITLE = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.nonPlatinumOauthTitle', {
  defaultMessage: 'Configuring OAuth for Custom Search Applications'
});
const NON_PLATINUM_OAUTH_DESCRIPTION = exports.NON_PLATINUM_OAUTH_DESCRIPTION = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.nonPlatinumOauthDescription', {
  defaultMessage: 'Configure an OAuth application for secure use of the Workplace Search Search API. Upgrade to a Platinum license to enable the Search API and create your OAuth application.'
});
const EXPLORE_PLATINUM_FEATURES_LINK = exports.EXPLORE_PLATINUM_FEATURES_LINK = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.explorePlatinumFeatures.link', {
  defaultMessage: 'Explore Platinum features'
});
const CUSTOMIZE_HEADER_TITLE = exports.CUSTOMIZE_HEADER_TITLE = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.customize.header.title', {
  defaultMessage: 'Customize Workplace Search'
});
const CUSTOMIZE_HEADER_DESCRIPTION = exports.CUSTOMIZE_HEADER_DESCRIPTION = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.customize.header.description', {
  defaultMessage: 'Personalize general organization settings.'
});
const CUSTOMIZE_NAME_LABEL = exports.CUSTOMIZE_NAME_LABEL = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.customize.name.label', {
  defaultMessage: 'Organization name'
});
const CUSTOMIZE_NAME_BUTTON = exports.CUSTOMIZE_NAME_BUTTON = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.customize.name.button', {
  defaultMessage: 'Save organization name'
});
const UPDATE_BUTTON = exports.UPDATE_BUTTON = _constants.UPDATE_BUTTON_LABEL;
const SAVE_BUTTON = exports.SAVE_BUTTON = _constants.SAVE_BUTTON_LABEL;
const CANCEL_BUTTON = exports.CANCEL_BUTTON = _constants.CANCEL_BUTTON_LABEL;
const RESET_BUTTON = exports.RESET_BUTTON = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.reset.button', {
  defaultMessage: 'Reset'
});
const CONFIGURE_BUTTON = exports.CONFIGURE_BUTTON = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.configure.button', {
  defaultMessage: 'Configure'
});
const OK_BUTTON = exports.OK_BUTTON = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.ok.button', {
  defaultMessage: 'Ok'
});
const PRIVATE_PLATINUM_LICENSE_CALLOUT = exports.PRIVATE_PLATINUM_LICENSE_CALLOUT = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.privatePlatinumCallout.text', {
  defaultMessage: 'Private Sources require a Platinum license.'
});
const SOURCE = exports.SOURCE = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.source.text', {
  defaultMessage: 'Source'
});
const PRIVATE_SOURCE = exports.PRIVATE_SOURCE = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.privateSource.text', {
  defaultMessage: 'Private Source'
});
const PRIVATE_SOURCES = exports.PRIVATE_SOURCES = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.privateSources.text', {
  defaultMessage: 'Private Sources'
});
const PRIVATE_CAN_CREATE_PAGE_TITLE = exports.PRIVATE_CAN_CREATE_PAGE_TITLE = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.private.canCreate.title', {
  defaultMessage: 'Manage private content sources'
});
const PRIVATE_VIEW_ONLY_PAGE_TITLE = exports.PRIVATE_VIEW_ONLY_PAGE_TITLE = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.private.vewOnly.title', {
  defaultMessage: 'Review Group Sources'
});
const PRIVATE_VIEW_ONLY_PAGE_DESCRIPTION = exports.PRIVATE_VIEW_ONLY_PAGE_DESCRIPTION = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.private.vewOnly.description', {
  defaultMessage: 'Review the status of all sources shared with your Group.'
});
const PRIVATE_CAN_CREATE_PAGE_DESCRIPTION = exports.PRIVATE_CAN_CREATE_PAGE_DESCRIPTION = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.private.canCreate.description', {
  defaultMessage: 'Review the status of all connected private sources, and manage private sources for your account.'
});
const ACCOUNT_SETTINGS_TITLE = exports.ACCOUNT_SETTINGS_TITLE = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.accountSettings.title', {
  defaultMessage: 'Account Settings'
});
const ACCOUNT_SETTINGS_DESCRIPTION = exports.ACCOUNT_SETTINGS_DESCRIPTION = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.accountSettings.description', {
  defaultMessage: 'Manage access, passwords, and other account settings.'
});
const CONFIRM_CHANGES_TEXT = exports.CONFIRM_CHANGES_TEXT = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.confirmChanges.text', {
  defaultMessage: 'Confirm changes'
});
const CONNECTORS_HEADER_TITLE = exports.CONNECTORS_HEADER_TITLE = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.connectors.header.title', {
  defaultMessage: 'Content source connectors'
});
const CONNECTORS_HEADER_DESCRIPTION = exports.CONNECTORS_HEADER_DESCRIPTION = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.connectors.header.description', {
  defaultMessage: 'All of your configurable connectors.'
});
const URL_LABEL = exports.URL_LABEL = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.url.label', {
  defaultMessage: 'URL'
});
const FIELD_LABEL = exports.FIELD_LABEL = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.field.label', {
  defaultMessage: 'Field'
});
const LABEL_LABEL = exports.LABEL_LABEL = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.label.label', {
  defaultMessage: 'Label'
});
const DESCRIPTION_LABEL = exports.DESCRIPTION_LABEL = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.description.label', {
  defaultMessage: 'Description'
});
const BLOCK_LABEL = exports.BLOCK_LABEL = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.blockLabel', {
  defaultMessage: 'Block'
});
const BETWEEN_LABEL = exports.BETWEEN_LABEL = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.betweenLabel', {
  defaultMessage: 'between'
});
const ON_LABEL = exports.ON_LABEL = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.onLabel', {
  defaultMessage: 'on'
});
const AND = exports.AND = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.and', {
  defaultMessage: 'and'
});
const UPDATE_LABEL = exports.UPDATE_LABEL = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.update.label', {
  defaultMessage: 'Update'
});
const ADD_LABEL = exports.ADD_LABEL = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.add.label', {
  defaultMessage: 'Add'
});
const ADD_FIELD_LABEL = exports.ADD_FIELD_LABEL = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.addField.label', {
  defaultMessage: 'Add field'
});
const EDIT_FIELD_LABEL = exports.EDIT_FIELD_LABEL = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.editField.label', {
  defaultMessage: 'Edit field'
});
const REMOVE_FIELD_LABEL = exports.REMOVE_FIELD_LABEL = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.removeField.label', {
  defaultMessage: 'Remove field'
});
const RECENT_ACTIVITY_TITLE = exports.RECENT_ACTIVITY_TITLE = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.recentActivity.title', {
  defaultMessage: 'Recent activity'
});
const CONFIRM_MODAL_TITLE = exports.CONFIRM_MODAL_TITLE = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.comfirmModal.title', {
  defaultMessage: 'Please confirm'
});
const REMOVE_BUTTON = exports.REMOVE_BUTTON = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.remove.button', {
  defaultMessage: 'Remove'
});
const COPY_TEXT = exports.COPY_TEXT = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.copyText', {
  defaultMessage: 'Copy'
});
const STATUS_POPOVER_TOOLTIP = exports.STATUS_POPOVER_TOOLTIP = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.statusPopoverTooltip', {
  defaultMessage: 'Click to view info'
});
const DOCUMENTS_HEADER = exports.DOCUMENTS_HEADER = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.documentsHeader', {
  defaultMessage: 'Documents'
});
const SEARCHABLE_HEADER = exports.SEARCHABLE_HEADER = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.searchableHeader', {
  defaultMessage: 'Searchable'
});
const PLATINUM_FEATURE = exports.PLATINUM_FEATURE = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.platinumFeature', {
  defaultMessage: 'Platinum feature'
});
const COPY_TOOLTIP = exports.COPY_TOOLTIP = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.copy.tooltip', {
  defaultMessage: 'Copy to clipboard'
});
const COPIED_TOOLTIP = exports.COPIED_TOOLTIP = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.copied.tooltip', {
  defaultMessage: 'Copied!'
});