"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ElasticsearchProductCard = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _constants = require("../../../../../common/constants");
var _doc_links = require("../../../shared/doc_links");
var _product_card = require("../product_card");
var _behavioral_analytics_product_card = require("./behavioral_analytics_product_card");
var _search_applications_product_card = require("./search_applications_product_card");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ElasticsearchProductCard = () => {
  return /*#__PURE__*/_react.default.createElement(_product_card.ProductCard, {
    "data-test-subj": "productCard-elasticsearch",
    description: _i18n.i18n.translate('xpack.enterpriseSearch.elasticsearch.productCardDescription', {
      defaultMessage: 'Ideal for bespoke applications, Elasticsearch helps you build highly customizable search and offers many different ingestion methods.'
    }),
    icon: "logoElasticsearch",
    name: _constants.ELASTICSEARCH_PLUGIN.NAME,
    productId: _constants.ELASTICSEARCH_PLUGIN.ID,
    emptyCta: true,
    cta: _i18n.i18n.translate('xpack.enterpriseSearch.elasticsearchCard.cta', {
      defaultMessage: 'Learn more'
    }),
    url: _doc_links.docLinks.elasticsearchGettingStarted,
    rightPanelItems: [/*#__PURE__*/_react.default.createElement(_search_applications_product_card.SearchApplicationsProductCard, {
      hasBorder: false,
      hasShadow: false
    }), /*#__PURE__*/_react.default.createElement(_behavioral_analytics_product_card.BehavioralAnalyticsProductCard, {
      hasBorder: false,
      hasShadow: false
    })]
  });
};
exports.ElasticsearchProductCard = ElasticsearchProductCard;