"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSyncRulesDescription = exports.SYNC_RULES_TABLE_ARIA_LABEL = exports.SYNC_RULES_TABLE_ADD_RULE_LABEL = exports.SYNC_RULES_LEARN_MORE_LINK = exports.REGEX_ERROR = exports.INCLUDE_EVERYTHING_ELSE_MESSAGE = exports.BASIC_TABLE_VALUE_TITLE = exports.BASIC_TABLE_RULE_TITLE = exports.BASIC_TABLE_POLICY_TITLE = exports.BASIC_TABLE_FIELD_TITLE = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const BASIC_TABLE_FIELD_TITLE = exports.BASIC_TABLE_FIELD_TITLE = _i18n.i18n.translate('xpack.enterpriseSearch.index.connector.syncRules.basicTable.fieldTitle', {
  defaultMessage: 'Field'
});
const BASIC_TABLE_POLICY_TITLE = exports.BASIC_TABLE_POLICY_TITLE = _i18n.i18n.translate('xpack.enterpriseSearch.index.connector.rule.basicTable.policyTitle', {
  defaultMessage: 'Policy'
});
const BASIC_TABLE_RULE_TITLE = exports.BASIC_TABLE_RULE_TITLE = _i18n.i18n.translate('xpack.enterpriseSearch.index.connector.syncRules.basicTable.ruleTitle', {
  defaultMessage: 'Rule'
});
const BASIC_TABLE_VALUE_TITLE = exports.BASIC_TABLE_VALUE_TITLE = _i18n.i18n.translate('xpack.enterpriseSearch.index.connector.syncRules.basicTable.valueTitle', {
  defaultMessage: 'Value'
});
const getSyncRulesDescription = indexName => _i18n.i18n.translate('xpack.enterpriseSearch.content.index.connector.syncRules.description', {
  defaultMessage: 'Add a sync rule to customize what data is synchronized from {indexName}. Everything is included by default, and documents are validated against the configured set of sync rules in the listed order.',
  values: {
    indexName
  }
});
exports.getSyncRulesDescription = getSyncRulesDescription;
const SYNC_RULES_LEARN_MORE_LINK = exports.SYNC_RULES_LEARN_MORE_LINK = _i18n.i18n.translate('xpack.enterpriseSearch.content.index.connector.syncRules.link', {
  defaultMessage: 'Learn more about customizing your sync rules.'
});
const SYNC_RULES_TABLE_ADD_RULE_LABEL = exports.SYNC_RULES_TABLE_ADD_RULE_LABEL = _i18n.i18n.translate('xpack.enterpriseSearch.content.index.connector.syncRules.table.addRuleLabel', {
  defaultMessage: 'Add sync rule'
});
const SYNC_RULES_TABLE_ARIA_LABEL = exports.SYNC_RULES_TABLE_ARIA_LABEL = _i18n.i18n.translate('xpack.enterpriseSearch.content.index.connector.syncRules.table.ariaLabel', {
  defaultMessage: 'Sync rules'
});
const REGEX_ERROR = exports.REGEX_ERROR = _i18n.i18n.translate('xpack.enterpriseSearch.content.index.connector.filteringRules.regExError', {
  defaultMessage: 'Value should be a regular expression'
});
const INCLUDE_EVERYTHING_ELSE_MESSAGE = exports.INCLUDE_EVERYTHING_ELSE_MESSAGE = _i18n.i18n.translate('xpack.enterpriseSearch.content.sources.basicRulesTable.includeEverythingMessage', {
  defaultMessage: 'Include everything else from this source'
});