"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SampleResponse = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _query_performance = require("../query_performance");
var _result_settings_logic = require("../result_settings_logic");
var _sample_response_logic = require("./sample_response_logic");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SampleResponse = () => {
  const {
    reducedServerResultFields
  } = (0, _kea.useValues)(_result_settings_logic.ResultSettingsLogic);
  const {
    query,
    response
  } = (0, _kea.useValues)(_sample_response_logic.SampleResponseLogic);
  const {
    queryChanged,
    getSearchResults
  } = (0, _kea.useActions)(_sample_response_logic.SampleResponseLogic);
  (0, _react.useEffect)(() => {
    getSearchResults(query, reducedServerResultFields);
  }, [query, reducedServerResultFields]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.resultSettings.sampleResponseTitle', {
    defaultMessage: 'Sample response'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_query_performance.QueryPerformance, null))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFieldSearch, {
    value: query,
    onChange: e => queryChanged(e.target.value),
    placeholder: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.resultSettings.sampleResponse.inputPlaceholder', {
      defaultMessage: 'Type a search query to test a response...'
    }),
    "data-test-subj": "ResultSettingsQuerySampleResponse"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), !!response && /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    language: "json",
    whiteSpace: "pre-wrap"
  }, typeof response === 'string' ? response : JSON.stringify(response, null, 2)));
};
exports.SampleResponse = SampleResponse;