"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getGenerateOrEndEdge = void 0;
var _get_generate_or_end_decision = require("./helpers/get_generate_or_end_decision");
var _get_has_zero_alerts = require("../helpers/get_has_zero_alerts");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getGenerateOrEndEdge = logger => {
  const edge = state => {
    logger === null || logger === void 0 ? void 0 : logger.debug(() => '---GENERATE OR END---');
    const {
      anonymizedAlerts
    } = state;
    const hasZeroAlerts = (0, _get_has_zero_alerts.getHasZeroAlerts)(anonymizedAlerts);
    const decision = (0, _get_generate_or_end_decision.getGenerateOrEndDecision)(hasZeroAlerts);
    logger === null || logger === void 0 ? void 0 : logger.debug(() => `generatOrEndEdge evaluated the following (derived) state:\n${JSON.stringify({
      anonymizedAlerts: anonymizedAlerts.length,
      hasZeroAlerts
    }, null, 2)}
\n---GENERATE OR END: ${decision}---`);
    return decision;
  };
  return edge;
};
exports.getGenerateOrEndEdge = getGenerateOrEndEdge;