"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.unflattenGrouping = exports.getGroupByObject = exports.getFormattedGroups = exports.getFormattedGroupBy = void 0;
var _objectUtils = require("@kbn/object-utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// TODO: Remove after updating the group logic in the log threshold rule
// https://github.com/elastic/kibana/issues/220006
const getGroupByObject = (groupBy, groupValueSet) => {
  const groupKeyValueMappingsObject = {};
  if (groupBy) {
    groupValueSet.forEach(groupValueStr => {
      const groupValueArray = groupValueStr.split(',');
      groupKeyValueMappingsObject[groupValueStr] = (0, _objectUtils.unflattenObject)(Array.isArray(groupBy) ? groupBy.reduce((result, groupKey, index) => {
        var _groupValueArray$inde;
        return {
          ...result,
          [groupKey]: (_groupValueArray$inde = groupValueArray[index]) === null || _groupValueArray$inde === void 0 ? void 0 : _groupValueArray$inde.trim()
        };
      }, {}) : {
        [groupBy]: groupValueStr
      });
    });
  }
  return groupKeyValueMappingsObject;
};
exports.getGroupByObject = getGroupByObject;
const unflattenGrouping = grouping => {
  if (grouping) {
    return (0, _objectUtils.unflattenObject)(grouping);
  }
};

// TODO: Remove after updating the group logic in the log threshold rule
// https://github.com/elastic/kibana/issues/220006
exports.unflattenGrouping = unflattenGrouping;
const getFormattedGroupBy = (groupBy, groupSet) => {
  const groupByKeysObjectMapping = {};
  if (groupBy) {
    groupSet.forEach(group => {
      const groupSetKeys = group.split(',');
      groupByKeysObjectMapping[group] = Array.isArray(groupBy) ? groupBy.reduce((result, groupByItem, index) => {
        var _groupSetKeys$index;
        result.push({
          field: groupByItem,
          value: (_groupSetKeys$index = groupSetKeys[index]) === null || _groupSetKeys$index === void 0 ? void 0 : _groupSetKeys$index.trim()
        });
        return result;
      }, []) : [{
        field: groupBy,
        value: group
      }];
    });
  }
  return groupByKeysObjectMapping;
};
exports.getFormattedGroupBy = getFormattedGroupBy;
const getFormattedGroups = grouping => {
  const groups = [];
  if (grouping) {
    const groupKeys = Object.keys(grouping);
    groupKeys.forEach(group => {
      groups.push({
        field: group,
        value: grouping[group]
      });
    });
  }
  return groups.length ? groups : undefined;
};
exports.getFormattedGroups = getFormattedGroups;