"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.healthFrameworkResponseSchema = exports.healthFrameworkResponseBodySchema = void 0;
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const alertingFrameworkHealthSchemaObject = {
  status: _configSchema.schema.oneOf([_configSchema.schema.literal('ok'), _configSchema.schema.literal('warn'), _configSchema.schema.literal('error')]),
  timestamp: _configSchema.schema.string()
};
const healthFrameworkResponseBodySchema = exports.healthFrameworkResponseBodySchema = _configSchema.schema.object({
  is_sufficiently_secure: _configSchema.schema.boolean({
    meta: {
      description: 'If false, security is enabled but TLS is not.'
    }
  }),
  has_permanent_encryption_key: _configSchema.schema.boolean({
    meta: {
      description: 'If false, the encryption key is not set'
    }
  }),
  alerting_framework_health: _configSchema.schema.object({
    decryption_health: _configSchema.schema.object(alertingFrameworkHealthSchemaObject, {
      meta: {
        description: 'The timestamp and status of the alert decryption.'
      }
    }),
    execution_health: _configSchema.schema.object(alertingFrameworkHealthSchemaObject, {
      meta: {
        description: 'The timestamp and status of the alert execution.'
      }
    }),
    read_health: _configSchema.schema.object(alertingFrameworkHealthSchemaObject, {
      meta: {
        description: 'The timestamp and status of the alert reading events.'
      }
    })
  }, {
    meta: {
      description: 'Three substates identify the health of the alerting framework: decryptionHealth, executionHealth, and readHealth.'
    }
  })
});
const healthFrameworkResponseSchema = exports.healthFrameworkResponseSchema = _configSchema.schema.object({
  body: healthFrameworkResponseBodySchema
});