const fs = require('fs')
const path = require('path')
const { environment } = require('@rails/webpacker')
const { railsEnv } = require('@rails/webpacker/package/env')
const erb = require('./loaders/erb')
const { optimize, DefinePlugin, EnvironmentPlugin, IgnorePlugin, ProvidePlugin } = require('webpack')
const GitRevisionPlugin = require('git-revision-webpack-plugin')

const gitRevisionPlugin = new GitRevisionPlugin()

environment.splitChunks()

//--------------------------------------------------------------------------------------------------
// Enable static content pre-compression
//
// WARNING: We will need to update filename parameters below when upgrading to the version 6.0+ of
//          the plugin since they changed how those path templates work. The new value for future
//          versions should be '[path][base].gz' and '[path][base].br'.
//
const zlib = require('zlib')
const CompressionPlugin = require('compression-webpack-plugin')
const compressableFileExts = /\.(js|css|html|json|ico|svg|eot|otf|ttf|map)$/

environment.plugins.prepend(
  'Gzip Compression',
  new CompressionPlugin({
    filename: '[path].gz[query]',
    test: compressableFileExts,
    algorithm: 'gzip',
    cache: true
  })
)

environment.plugins.prepend(
  'Brotli Compression',
  new CompressionPlugin({
    filename: '[path].br[query]',
    test: compressableFileExts,
    algorithm: 'brotliCompress',
    cache: true
  })
)

//--------------------------------------------------------------------------------------------------
environment.plugins.prepend(
  'ProvidePlugin',
  new ProvidePlugin({
    React: 'react',
    PropTypes: 'prop-types',
    Immutable: 'immutable'
  })
)

environment.plugins.prepend(
  'Environment',
  new EnvironmentPlugin({
    NODE_ENV: process.env.NODE_ENV,
    VERSION: (gitRevisionPlugin.commithash() || 'development')
  })
)

environment.plugins.append(
  'MomentLocalesIgnorePlugin',
  new IgnorePlugin(/^\.\/locale$/, /moment$/)
)

const productVersionPath = path.join(__dirname, '..', 'product_version')
const productVersion = fs.readFileSync(productVersionPath, 'utf8').trim()
const shortProductVersion = productVersion.replace(/^([1-9]+)\.([0-9]+).+$/, '$1.$2')

environment.plugins.append(
  'DefinePlugin',
  new DefinePlugin({
    'PRODUCT_VERSION': JSON.stringify(shortProductVersion),
    'window.noZensmooth': 'true'
  })
)

environment.loaders.prepend('erb', erb)

// node_modules on ci is a symlink and clipboard.js breaks unless we set this to false
environment.config.set('resolve.symlinks', false)

module.exports = environment
