# frozen_string_literal: true

class Views::SessionFailure::Index < ::Views::Base
  needs(:error_message => nil)

  def content
    doctype!

    html(:lang => 'en') do
      head do
        common_meta_tags
      end

      body do
        javascript(redirect_js)

        noscript do
          p(error_message) if error_message.present?
          link_to('Go to login', new_user_session_path)
        end
      end
    end
  end

  private

  def redirect_js
    <<-JAVASCRIPT
      (function() {
        var redirect = window.location.href.slice(window.location.origin.length);
        window.location.href = '/login?redirect=' + encodeURIComponent(redirect);
      })();
    JAVASCRIPT
  end
end
