/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.rack;

import java.util.Collection;
import java.util.LinkedHashSet;
import org.jruby.Ruby;
import org.jruby.rack.RackApplication;
import org.jruby.rack.RackApplicationFactory;
import org.jruby.rack.RackConfig;
import org.jruby.rack.RackContext;
import org.jruby.rack.RackException;
import org.jruby.rack.RackInitializationException;
import org.jruby.rack.RackLogger;

public abstract class RackApplicationFactoryDecorator
implements RackApplicationFactory,
RackApplicationFactory.Decorator {
    private final RackApplicationFactory delegate;
    private volatile RackContext context;
    private volatile RuntimeException initError;

    protected RackApplicationFactoryDecorator(RackApplicationFactory delegate) {
        this.delegate = delegate;
    }

    @Override
    public RackApplicationFactory getDelegate() {
        return this.delegate;
    }

    @Deprecated
    public RackApplicationFactory getRealFactory() {
        return this.getDelegate();
    }

    public RackContext getContext() {
        return this.context;
    }

    public void setContext(RackContext context) {
        this.context = context;
    }

    public RackContext getRackContext() {
        return this.context;
    }

    public RuntimeException getInitError() {
        return this.initError;
    }

    protected synchronized void setInitError(RuntimeException initError) {
        this.initError = initError;
    }

    @Override
    public void init(RackContext context) throws RackInitializationException {
        this.setContext(context);
        try {
            this.doInit();
        }
        catch (Exception e) {
            this.initError = RackInitializationException.wrap(e);
            throw this.initError;
        }
    }

    protected void doInit() throws Exception {
        this.getDelegate().init(this.context);
    }

    @Override
    public void destroy() {
        this.getDelegate().destroy();
    }

    @Override
    public RackApplication getApplication() throws RackException {
        RuntimeException error = this.getInitError();
        if (error != null) {
            this.log(RackLogger.Level.DEBUG, "due a previous initialization failure application instance can not be returned");
            throw error;
        }
        return this.getApplicationImpl();
    }

    protected abstract RackApplication getApplicationImpl();

    @Override
    public RackApplication getErrorApplication() {
        return this.getDelegate().getErrorApplication();
    }

    protected RackConfig getConfig() {
        return this.getContextBang().getConfig();
    }

    protected void log(RackLogger.Level level, String message) {
        this.getContextBang().log(level, message);
    }

    @Deprecated
    protected void log(String level, String message) {
        this.getContextBang().log(level, message);
    }

    protected void log(RackLogger.Level level, String message, Exception e) {
        this.getContextBang().log(level, message, (Throwable)e);
    }

    @Deprecated
    protected void log(String level, String message, Exception e) {
        this.getContextBang().log(level, message, (Throwable)e);
    }

    private RackContext getContextBang() throws IllegalStateException {
        RackContext context = this.getContext();
        if (context == null) {
            throw new IllegalStateException("no context");
        }
        return context;
    }

    public abstract Collection<RackApplication> getManagedApplications();

    public static Collection<Ruby> getManagedRuntimes(RackApplicationFactoryDecorator factory) {
        Collection<RackApplication> apps = factory.getManagedApplications();
        if (apps == null) {
            return null;
        }
        LinkedHashSet<Ruby> runtimes = new LinkedHashSet<Ruby>(apps.size());
        for (RackApplication app : apps) {
            runtimes.add(app.getRuntime());
        }
        return runtimes;
    }
}

