/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.thumbnails4j.xlsx;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.util.Formatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.poi.ss.format.CellFormat;
import org.apache.poi.ss.format.CellFormatResult;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.util.IOUtils;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;

public class XlsxToHtmlSerializer {
    public static int MAX_COLS = 5;
    public static int MAX_ROWS = 20;
    public static int HEADER_COLUMN_WIDTH_INDEX = -1;
    public static int TABLE_WIDTH_INDEX = -2;
    public static String DEFAULT_CLASS = "excelDefaults";
    public static Map<BorderStyle, String> BORDER_STYLE_MAP = new HashMap<BorderStyle, String>();
    public static Map<HorizontalAlignment, String> HORIZONTAL_ALIGNMENT = new HashMap<HorizontalAlignment, String>();
    public static Map<VerticalAlignment, String> VERTICAL_ALIGNMENT = new HashMap<VerticalAlignment, String>();
    private final Workbook workbook;
    private boolean gotBounds = false;
    private int firstColumn = 0;
    private int endColumn = 0;

    static {
        BORDER_STYLE_MAP.put(BorderStyle.DASH_DOT, "solid 1pt");
        BORDER_STYLE_MAP.put(BorderStyle.DASH_DOT_DOT, "solid 1pt");
        BORDER_STYLE_MAP.put(BorderStyle.DASHED, "solid 1pt");
        BORDER_STYLE_MAP.put(BorderStyle.DOTTED, "dotted 1pt");
        BORDER_STYLE_MAP.put(BorderStyle.DOUBLE, "double 3pt");
        BORDER_STYLE_MAP.put(BorderStyle.HAIR, "solid 1px");
        BORDER_STYLE_MAP.put(BorderStyle.MEDIUM, "solid 2pt");
        BORDER_STYLE_MAP.put(BorderStyle.MEDIUM_DASH_DOT, "solid 2pt");
        BORDER_STYLE_MAP.put(BorderStyle.MEDIUM_DASH_DOT_DOT, "solid 2pt");
        BORDER_STYLE_MAP.put(BorderStyle.MEDIUM_DASHED, "solid 2pt");
        BORDER_STYLE_MAP.put(BorderStyle.NONE, "none");
        BORDER_STYLE_MAP.put(BorderStyle.SLANTED_DASH_DOT, "solid 2pt");
        BORDER_STYLE_MAP.put(BorderStyle.THICK, "solid 3pt");
        BORDER_STYLE_MAP.put(BorderStyle.THIN, "solid 1pt");
        HORIZONTAL_ALIGNMENT.put(HorizontalAlignment.LEFT, "left");
        HORIZONTAL_ALIGNMENT.put(HorizontalAlignment.CENTER, "center");
        HORIZONTAL_ALIGNMENT.put(HorizontalAlignment.RIGHT, "right");
        HORIZONTAL_ALIGNMENT.put(HorizontalAlignment.FILL, "left");
        HORIZONTAL_ALIGNMENT.put(HorizontalAlignment.JUSTIFY, "left");
        HORIZONTAL_ALIGNMENT.put(HorizontalAlignment.CENTER_SELECTION, "center");
        VERTICAL_ALIGNMENT.put(VerticalAlignment.BOTTOM, "bottom");
        VERTICAL_ALIGNMENT.put(VerticalAlignment.CENTER, "middle");
        VERTICAL_ALIGNMENT.put(VerticalAlignment.TOP, "top");
    }

    public XlsxToHtmlSerializer(Workbook workbook) {
        this.workbook = workbook;
    }

    public byte[] getHtml() {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        Formatter html = new Formatter(outputStream);
        try {
            html.format("<html>%n", new Object[0]);
            html.format("<head>%n", new Object[0]);
            this.printInlineStyle(html);
            html.format("</head>%n", new Object[0]);
            html.format("<body>%n", new Object[0]);
            this.printSheet(html, this.workbook.getSheetAt(0));
            html.format("</body>%n", new Object[0]);
            html.format("</html>%n", new Object[0]);
            html.flush();
            byte[] byArray = outputStream.toByteArray();
            return byArray;
        }
        finally {
            IOUtils.closeQuietly((Closeable)html);
        }
    }

    private void printInlineStyle(Formatter html) {
        html.format("<style type=\"text/css\">%n", new Object[0]);
        this.printStyles(html);
        html.format("</style>%n", new Object[0]);
    }

    private void printStyles(Formatter html) {
        html.format(".excelDefaults {\n        background-color: white;\n        color: black;\n        text-decoration: none;\n        direction: ltr;\n        text-transform: none;\n        text-indent: 0;\n        letter-spacing: 0;\n        word-spacing: 0;\n        white-space: pre-wrap;\n        unicode-bidi: normal;\n        background-image: none;\n        text-shadow: none;\n        list-style-image: none;\n        list-style-type: none;\n        padding: 0;\n        margin: 0;\n        border-collapse: collapse;\n        vertical-align: bottom;\n        font-style: normal;\n        font-family: sans-serif;\n        font-variant: normal;\n        font-weight: normal;\n        font-size: 10pt;\n        text-align: right;\n        table-layout: fixed;\n        word-wrap: break-word;\n        overflow-wrap: break-word;\n      }\n\n      .excelDefaults td {\n        padding: 1px 5px;\n      }", new Object[0]);
        HashSet<CellStyle> seen = new HashSet<CellStyle>();
        int i = 0;
        while (i < this.workbook.getNumberOfSheets()) {
            Sheet sheet = this.workbook.getSheetAt(i);
            for (Row row : sheet) {
                for (Cell cell : row) {
                    CellStyle style = cell.getCellStyle();
                    if (seen.contains(style)) continue;
                    this.printStyle(html, style);
                    seen.add(style);
                }
            }
            ++i;
        }
    }

    private void printStyle(Formatter html, CellStyle style) {
        html.format(".%s .%s {%n", DEFAULT_CLASS, this.styleName(style));
        this.styleContents(html, style);
        html.format("}%n", new Object[0]);
    }

    private void styleContents(Formatter html, CellStyle style) {
        this.styleOut(html, "text-align", HORIZONTAL_ALIGNMENT.get(style.getAlignment()));
        this.styleOut(html, "vertical-align", VERTICAL_ALIGNMENT.get(style.getVerticalAlignment()));
        this.fontStyle(html, style);
        this.borderStyles(html, style);
        this.colorStyles(html, style);
    }

    private void borderStyles(Formatter html, CellStyle style) {
        this.styleOut(html, "border-left", BORDER_STYLE_MAP.get(style.getBorderLeft()));
        this.styleOut(html, "border-right", BORDER_STYLE_MAP.get(style.getBorderRight()));
        this.styleOut(html, "border-top", BORDER_STYLE_MAP.get(style.getBorderTop()));
        this.styleOut(html, "border-bottom", BORDER_STYLE_MAP.get(style.getBorderBottom()));
    }

    private void colorStyles(Formatter html, CellStyle style) {
        this.styleColor(html, ((XSSFCellStyle)style).getFont().getXSSFColor());
    }

    private void styleColor(Formatter html, XSSFColor color) {
        byte[] rgb;
        if (color != null && !color.isAuto() && (rgb = color.getRGB()) != null) {
            html.format(" %s: #%02x%02x%02x;%n", "color", rgb[0], rgb[1], rgb[2]);
        }
    }

    private void fontStyle(Formatter html, CellStyle style) {
        Font font = this.workbook.getFontAt(style.getFontIndexAsInt());
        if (font.getBold()) {
            html.format("  font-weight: bold;%n", new Object[0]);
        }
        if (font.getItalic()) {
            html.format("   font-style: italic;%n", new Object[0]);
        }
        html.format("  font-size: %dpt;%n", font.getFontHeightInPoints());
    }

    private String styleName(CellStyle style) {
        style = style == null ? this.workbook.getCellStyleAt(0) : style;
        return String.format("style_%02x", style.getIndex());
    }

    private void styleOut(Formatter html, String attr, String value) {
        if (value != null) {
            html.format("  %s: %s;%n", attr, value);
        }
    }

    private void printSheet(Formatter html, Sheet sheet) {
        Map<Integer, Integer> widths = this.computeWidths(sheet);
        int tableWidth = widths.get(TABLE_WIDTH_INDEX);
        html.format("<table class=\"%s\" style=\"width:%dpx; border: solid 1px black;\" cellspacing=\"0\">%n", DEFAULT_CLASS, tableWidth);
        this.printSheetContent(html, sheet);
        html.format("</table>%n", new Object[0]);
    }

    private Map<Integer, Integer> computeWidths(Sheet sheet) {
        HashMap<Integer, Integer> results = new HashMap<Integer, Integer>();
        int tableWidth = 0;
        this.ensureColumnBounds(sheet);
        int headerCharCount = ("" + sheet.getLastRowNum()).length();
        int headerColWidth = this.widthToPixels((double)(headerCharCount + 1) * 256.0);
        results.put(HEADER_COLUMN_WIDTH_INDEX, headerColWidth);
        tableWidth += headerColWidth;
        int i = this.firstColumn;
        while (i < this.endColumn - 1) {
            int col_width = this.widthToPixels(sheet.getColumnWidth(i));
            results.put(i, col_width);
            tableWidth += col_width;
            ++i;
        }
        results.put(TABLE_WIDTH_INDEX, tableWidth);
        return results;
    }

    private int widthToPixels(double widthUnits) {
        return Math.toIntExact(Math.round(widthUnits * 9.0 / 256.0));
    }

    private CellType ultimateCellType(Cell cell) {
        CellType type = cell.getCellType();
        if (type == CellType.FORMULA) {
            type = cell.getCachedFormulaResultType();
        }
        return type;
    }

    private void ensureColumnBounds(Sheet sheet) {
        if (!this.gotBounds) {
            this.firstColumn = sheet.getRow(0) == null ? 0 : Integer.MAX_VALUE;
            this.endColumn = 0;
            for (Row row : sheet) {
                short firstCell = row.getFirstCellNum();
                if (firstCell < 0) continue;
                this.firstColumn = Math.min(this.firstColumn, firstCell);
                this.endColumn = Math.min(Math.max(this.endColumn, row.getLastCellNum()), MAX_COLS);
            }
            this.gotBounds = true;
        }
    }

    private void printSheetContent(Formatter html, Sheet sheet) {
        html.format("<tbody>%n", new Object[0]);
        int lastRow = Math.min(sheet.getFirstRowNum() + MAX_ROWS - 1, sheet.getLastRowNum());
        int i = sheet.getFirstRowNum();
        while (i < lastRow) {
            Row row = sheet.getRow(i);
            html.format("  <tr>%n", new Object[0]);
            if (row != null) {
                int j = this.firstColumn;
                while (j < this.endColumn - 1) {
                    Cell cell;
                    String content = "&nbsp;";
                    String attrs = "";
                    CellStyle style = null;
                    if (j >= row.getFirstCellNum() && j < row.getLastCellNum() && (cell = row.getCell(j)) != null) {
                        style = cell.getCellStyle();
                        attrs = this.tagStyle(cell, style);
                        CellFormat cf = CellFormat.getInstance((String)style.getDataFormatString());
                        CellFormatResult result = cf.apply(cell);
                        content = result.text;
                        if (content.isEmpty()) {
                            content = "&nbsp;";
                        }
                    }
                    html.format("    <td class=\"%s\" %s>%s</td>%n", this.styleName(style), attrs, content);
                    ++j;
                }
            }
            html.format("  </tr>%n", new Object[0]);
            ++i;
        }
        html.format("</tbody>%n", new Object[0]);
    }

    private String tagStyle(Cell cell, CellStyle style) {
        if (style.getAlignment() == HorizontalAlignment.GENERAL) {
            CellType ultimateCellType = this.ultimateCellType(cell);
            if (ultimateCellType == CellType.STRING) {
                return "style=\"text-align: left;\"";
            }
            if (ultimateCellType == CellType.BOOLEAN || ultimateCellType == CellType.ERROR) {
                return "style=\"text-align: center;\"";
            }
        }
        return "";
    }
}

