# frozen_string_literal: true
#
class Views::FritoPie::Accounts::Onboarding < ::Views::Base
  needs :fp_account

  def content
    doctype!
    html(:lang => 'en', :class => 'no-js') do
      head do
        title('Elastic Workplace Search')
        widget Views::Shared::Favicon, :product => 'workplace-search'
        common_meta_tags

        stylesheet_packs_with_chunks_tag('eui')
        stylesheet_link_tag('es/main')

        javascript_include_tag 'jquery'
      end

      body(:class => 'layout layout--onboarding') do
        div(:class => 'onboarding') do
          div(:class => 'onboarding__brand') do
            image_tag('frito_pie/workplace-search-logo.svg')
            div(:class => 'onboarding__brand-text') do
              text 'Workplace Search'
            end
          end
          div(:class => 'onboarding-slides', :"data-slides" => '1') do
            div(:class => 'onboarding-slides__slide onboarding-slides__slide--active') do
              div(:class => 'onboarding-slide') do
                div(:class => 'onboarding-slide__brand') do
                  image_tag('frito_pie/workplace-search-logo.svg')
                  div(:class => 'onboarding-slide__brand-text') do
                    text 'Workplace Search'
                  end
                end
                div(:class => 'onboarding-slide__content') do
                  div(:class => 'onboarding-slide__title') do
                    text 'Welcome to'
                    br
                    if fp_account.user.first_name.blank?
                      text ' Workplace Search!'
                    else
                      text " Workplace Search, #{fp_account.user.first_name}!"
                    end
                  end
                  p(:class => 'onboarding-slide__subtitle') do
                    text 'All of '
                    strong "#{fp_account.frito_pie_organization.name}'s"
                    text ' content is a search away'
                  end
                  div(:class => 'onboarding-slide__description') do
                    p('Workplace Search lets you find any document, conversation, account or person across all of your systems, creating a powerful, unified discovery experience.')
                  end
                  a('Start Searching', :class => 'onboarding-slide__action button button--blue', :href => search_app_frito_pie_account_url)
                end
              end
              widget Views::FritoPie::Components::OnboardingCarousel
            end
          end
        end

        javascript_include_tag 'jquery'
        javascript_include_tag 'shared/app'
        rawtext content_for :page_javascript
      end
    end
  end
end
