class ::Views::Base < ::Fortitude::Widget
  include Concerns::ReactConcern

  doctype :html5

  implicit_shared_variable_access false
  use_instance_variables_for_assigns false

  if AppConfig.env_development_like?
    enforce_element_nesting_rules true
    enforce_attribute_rules       true
    enforce_id_uniqueness         true
  end

  include EuiIconsHelper

  def common_meta_tags
    widget Views::Shared::CommonMetaTags
  end

  def icon(name, classes: '')
    rawtext %{
      <svg class="icon #{classes}">
        <use xlink:href="##{name}"></use>
      </svg>
    }
  end

  def flash_message
    if flash_msg = flash[:success]
      div(flash_msg, :class => 'alert alert--success')
    end
    if flash_msg = flash[:error]
      div(flash_msg, :class => 'alert alert--error')
    end
  end

  def react(component, tag: :div, props: {}, data: {}, **kwargs)
    validate_react_props!(props)
    data = data.merge(
      :react => {
        :component => component,
        :props => STJSON.dump(props)
      }
    )
    send(tag, :data => data, **kwargs)
  end
end
