/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.rack;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import org.jruby.exceptions.RaiseException;

public class RackException
extends RuntimeException {
    public RackException(String message) {
        super(message);
    }

    public RackException(Throwable cause) {
        super(cause);
    }

    public RackException(String message, Throwable cause) {
        super(message, cause);
    }

    public Throwable getRootCause() {
        Throwable cause = this.getCause();
        if (cause != null) {
            while (cause.getCause() != null) {
                cause = cause.getCause();
            }
        }
        return cause;
    }

    static RackException wrap(Exception e) {
        if (e instanceof RackException) {
            return (RackException)e;
        }
        return new RackException(e);
    }

    static String exceptionMessage(RaiseException e) {
        if (e != null) {
            StringBuilder st = new StringBuilder();
            st.append(e.getException().toString()).append('\n');
            ByteArrayOutputStream b = new ByteArrayOutputStream();
            e.getException().printBacktrace(new PrintStream(b));
            st.append(b.toString());
            return st.toString();
        }
        return null;
    }
}

