/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.fieldcomparator;

import java.io.IOException;
import java.util.function.Function;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.LeafFieldComparator;
import org.apache.lucene.search.Pruning;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.comparators.LongComparator;
import org.apache.lucene.util.BitSet;
import org.elasticsearch.common.time.DateUtils;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.fielddata.FieldData;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.index.fielddata.LeafNumericFieldData;
import org.elasticsearch.index.fielddata.plain.SortedNumericIndexFieldData;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.MultiValueMode;
import org.elasticsearch.search.sort.BucketedSort;
import org.elasticsearch.search.sort.SortOrder;

public class LongValuesComparatorSource
extends IndexFieldData.XFieldComparatorSource {
    final IndexNumericFieldData indexFieldData;
    private final Function<SortedNumericDocValues, SortedNumericDocValues> converter;
    private final IndexNumericFieldData.NumericType targetNumericType;

    public LongValuesComparatorSource(IndexNumericFieldData indexFieldData, @Nullable Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested, IndexNumericFieldData.NumericType targetNumericType) {
        this(indexFieldData, missingValue, sortMode, nested, null, targetNumericType);
    }

    public LongValuesComparatorSource(IndexNumericFieldData indexFieldData, @Nullable Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested, Function<SortedNumericDocValues, SortedNumericDocValues> converter, IndexNumericFieldData.NumericType targetNumericType) {
        super(missingValue, sortMode, nested);
        this.indexFieldData = indexFieldData;
        this.converter = converter;
        this.targetNumericType = targetNumericType;
    }

    @Override
    public SortField.Type reducedType() {
        return SortField.Type.LONG;
    }

    private SortedNumericDocValues loadDocValues(LeafReaderContext context) {
        LeafNumericFieldData data = (LeafNumericFieldData)this.indexFieldData.load(context);
        SortedNumericDocValues values = data instanceof SortedNumericIndexFieldData.NanoSecondFieldData ? ((SortedNumericIndexFieldData.NanoSecondFieldData)data).getLongValuesAsNanos() : data.getLongValues();
        return this.converter != null ? this.converter.apply(values) : values;
    }

    NumericDocValues getNumericDocValues(LeafReaderContext context, long missingValue) throws IOException {
        SortedNumericDocValues values = this.loadDocValues(context);
        if (this.nested == null) {
            return FieldData.replaceMissing(this.sortMode.select(values), missingValue);
        }
        BitSet rootDocs = this.nested.rootDocs(context);
        DocIdSetIterator innerDocs = this.nested.innerDocs(context);
        int maxChildren = this.nested.getNestedSort() != null ? this.nested.getNestedSort().getMaxChildren() : Integer.MAX_VALUE;
        return this.sortMode.select(values, missingValue, rootDocs, innerDocs, maxChildren);
    }

    public FieldComparator<?> newComparator(String fieldname, int numHits, Pruning enableSkipping, boolean reversed) {
        assert (this.indexFieldData == null || fieldname.equals(this.indexFieldData.getFieldName()));
        final long lMissingValue = (Long)this.missingObject(this.missingValue, reversed);
        return new LongComparator(numHits, null, null, reversed, Pruning.NONE){

            public LeafFieldComparator getLeafComparator(LeafReaderContext context) throws IOException {
                return new LongComparator.LongLeafComparator(context){

                    protected NumericDocValues getNumericDocValues(LeafReaderContext context, String field) throws IOException {
                        return LongValuesComparatorSource.this.getNumericDocValues(context, lMissingValue);
                    }
                };
            }
        };
    }

    @Override
    public BucketedSort newBucketedSort(BigArrays bigArrays, final SortOrder sortOrder, DocValueFormat format, int bucketSize, BucketedSort.ExtraData extra) {
        return new BucketedSort.ForLongs(bigArrays, sortOrder, format, bucketSize, extra){
            private final long lMissingValue;
            {
                super(bigArrays, sortOrder3, format, bucketSize, extra);
                this.lMissingValue = (Long)LongValuesComparatorSource.this.missingObject(LongValuesComparatorSource.this.missingValue, sortOrder == SortOrder.DESC);
            }

            @Override
            public BucketedSort.ForLongs.Leaf forLeaf(final LeafReaderContext ctx) throws IOException {
                return new BucketedSort.ForLongs.Leaf(ctx){
                    private final NumericDocValues docValues;
                    private long docValue;
                    {
                        super(this, ctx2);
                        this.docValues = LongValuesComparatorSource.this.getNumericDocValues(ctx, lMissingValue);
                    }

                    @Override
                    protected boolean advanceExact(int doc) throws IOException {
                        if (this.docValues.advanceExact(doc)) {
                            this.docValue = this.docValues.longValue();
                            return true;
                        }
                        return false;
                    }

                    @Override
                    protected long docValue() {
                        return this.docValue;
                    }
                };
            }
        };
    }

    @Override
    public Object missingObject(Object missingValue, boolean reversed) {
        if (this.targetNumericType == IndexNumericFieldData.NumericType.DATE_NANOSECONDS && (LongValuesComparatorSource.sortMissingFirst(missingValue) || LongValuesComparatorSource.sortMissingLast(missingValue))) {
            boolean min = LongValuesComparatorSource.sortMissingFirst(missingValue) ^ reversed;
            return min ? 0L : DateUtils.MAX_NANOSECOND;
        }
        return super.missingObject(missingValue, reversed);
    }
}

