/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.inference.trainedmodel;

import java.io.IOException;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.action.PutTrainedModelVocabularyAction;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.Tokenization;

public class XLMRobertaTokenization
extends Tokenization {
    public static final String NAME = "xlm_roberta";
    public static final String MASK_TOKEN = "<mask>";
    private static final ConstructingObjectParser<XLMRobertaTokenization, Void> LENIENT_PARSER = XLMRobertaTokenization.createParser(true);
    private static final ConstructingObjectParser<XLMRobertaTokenization, Void> STRICT_PARSER = XLMRobertaTokenization.createParser(false);

    public static ConstructingObjectParser<XLMRobertaTokenization, Void> createParser(boolean ignoreUnknownFields) {
        ConstructingObjectParser parser = new ConstructingObjectParser("xlm_roberta_tokenization", ignoreUnknownFields, a -> new XLMRobertaTokenization((Boolean)a[0], (Boolean)a[1], (Integer)a[2], a[3] == null ? null : Tokenization.Truncate.fromString((String)a[3]), (Integer)a[4]));
        XLMRobertaTokenization.declareCommonFields(parser);
        return parser;
    }

    public static XLMRobertaTokenization fromXContent(XContentParser parser, boolean lenient) {
        return lenient ? (XLMRobertaTokenization)LENIENT_PARSER.apply(parser, null) : (XLMRobertaTokenization)STRICT_PARSER.apply(parser, null);
    }

    private XLMRobertaTokenization(@Nullable Boolean doLowerCase, @Nullable Boolean withSpecialTokens, @Nullable Integer maxSequenceLength, @Nullable Tokenization.Truncate truncate, @Nullable Integer span) {
        this(withSpecialTokens, maxSequenceLength, truncate, span);
        if (doLowerCase != null && doLowerCase.booleanValue()) {
            throw new IllegalArgumentException("unable to set [do_lower_case] to [true] for XLMRoberta tokenizer");
        }
    }

    public XLMRobertaTokenization(@Nullable Boolean withSpecialTokens, @Nullable Integer maxSequenceLength, @Nullable Tokenization.Truncate truncate, @Nullable Integer span) {
        super(false, withSpecialTokens, maxSequenceLength, truncate, span);
    }

    public XLMRobertaTokenization(StreamInput in) throws IOException {
        super(in);
    }

    @Override
    protected Tokenization buildWindowingTokenization(int maxSeqLength, int span) {
        return new XLMRobertaTokenization(this.withSpecialTokens, maxSeqLength, Tokenization.Truncate.NONE, span);
    }

    public String getWriteableName() {
        return NAME;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
    }

    @Override
    public String getMaskToken() {
        return MASK_TOKEN;
    }

    @Override
    XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void validateVocabulary(PutTrainedModelVocabularyAction.Request request) {
        if (request.getScores().isEmpty()) {
            throw new ElasticsearchStatusException("cannot put vocabulary for model [{}] as tokenizer type [{}] requires [{}] to be provided and non-empty", RestStatus.BAD_REQUEST, new Object[]{request.getModelId(), this.getName(), PutTrainedModelVocabularyAction.Request.SCORES.getPreferredName()});
        }
    }
}

