/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.delayedshard;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.CardinalityUpperBound;
import org.elasticsearch.search.aggregations.bucket.filter.FilterAggregationBuilder;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public class DelayedShardAggregationBuilder
extends AbstractAggregationBuilder<DelayedShardAggregationBuilder> {
    public static final String NAME = "shard_delay";
    private TimeValue delay;
    static final ConstructingObjectParser<DelayedShardAggregationBuilder, String> PARSER = new ConstructingObjectParser("shard_delay", false, (args, name) -> new DelayedShardAggregationBuilder((String)name, TimeValue.parseTimeValue((String)((String)args[0]), (String)"value")));

    public DelayedShardAggregationBuilder(String name, TimeValue delay) {
        super(name);
        this.delay = delay;
    }

    public DelayedShardAggregationBuilder(StreamInput in) throws IOException {
        super(in);
        this.delay = in.readTimeValue();
    }

    protected AggregationBuilder shallowCopy(AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metaData) {
        return new DelayedShardAggregationBuilder(this.name, this.delay);
    }

    public AggregationBuilder.BucketCardinality bucketCardinality() {
        return AggregationBuilder.BucketCardinality.ONE;
    }

    public String getType() {
        return NAME;
    }

    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeTimeValue(this.delay);
    }

    protected XContentBuilder internalXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("value", this.delay.toString());
        builder.endObject();
        return builder;
    }

    protected AggregatorFactory doBuild(AggregationContext context, AggregatorFactory parent, AggregatorFactories.Builder subfactoriesBuilder) throws IOException {
        context.nowInMillis();
        FilterAggregationBuilder filterAgg = (FilterAggregationBuilder)new FilterAggregationBuilder(this.name, (QueryBuilder)QueryBuilders.matchAllQuery()).subAggregations(subfactoriesBuilder);
        final AggregatorFactory factory = filterAgg.build(context, parent);
        return new AggregatorFactory(this.name, context, parent, subfactoriesBuilder, this.metadata){

            protected Aggregator createInternal(Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
                long start = this.context.getRelativeTimeInMillis();
                long sleepTime = Math.min(DelayedShardAggregationBuilder.this.delay.getMillis(), 100L);
                while (!this.context.isCancelled()) {
                    try {
                        Thread.sleep(sleepTime);
                    }
                    catch (InterruptedException e) {
                        throw new IOException(e);
                    }
                    if (this.context.getRelativeTimeInMillis() - start < DelayedShardAggregationBuilder.this.delay.getMillis()) continue;
                }
                return factory.create(parent, cardinality);
            }
        };
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DelayedShardAggregationBuilder that = (DelayedShardAggregationBuilder)((Object)o);
        return Objects.equals(this.delay, that.delay);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.delay);
    }

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.V_7_10_0;
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("value", new String[0]));
    }
}

