/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script;

import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.ingest.IngestDocument;
import org.elasticsearch.script.Metadata;

public class ReindexMetadata
extends Metadata {
    static final Map<String, Metadata.FieldProperty<?>> PROPERTIES = Map.of("_index", ObjectField.withWritable(), "_id", ObjectField.withWritable().withNullable(), "_version", LongField.withWritable().withNullable(), "_routing", StringField.withWritable().withNullable(), "op", StringField.withWritable().withValidation(ReindexMetadata.stringSetValidator(Set.of("noop", "index", "delete"))), "_now", LongField);
    protected final String index;
    protected final String id;
    protected final Long version;
    protected final String routing;

    public ReindexMetadata(String index, String id, Long version, String routing, String op, long timestamp) {
        super(ReindexMetadata.metadataMap(index, id, version, routing, op, timestamp), PROPERTIES);
        this.index = index;
        this.id = id;
        this.version = version;
        this.routing = routing;
    }

    protected static Map<String, Object> metadataMap(String index, String id, Long version, String routing, String op, long timestamp) {
        Map<String, Object> metadata = Maps.newHashMapWithExpectedSize(IngestDocument.Metadata.values().length);
        metadata.put("_index", index);
        metadata.put("_id", id);
        metadata.put("_version", version);
        metadata.put("_routing", routing);
        metadata.put("op", op);
        metadata.put("_now", timestamp);
        return metadata;
    }

    @Override
    public long getVersion() {
        Number version = this.getNumber("_version");
        if (version == null) {
            return Long.MIN_VALUE;
        }
        return version.longValue();
    }

    public boolean isVersionInternal() {
        return this.get("_version") == null;
    }

    public static boolean isVersionInternal(Metadata receiver) {
        return receiver.get("_version") == null;
    }

    public static void setVersionToInternal(Metadata receiver) {
        receiver.put("_version", null);
    }

    public boolean versionChanged() {
        Number updated = this.getNumber("_version");
        if (this.version == null || updated == null) {
            return this.version != updated;
        }
        return this.version.longValue() != updated.longValue();
    }

    public boolean indexChanged() {
        return !Objects.equals(this.index, this.getString("_index"));
    }

    public boolean idChanged() {
        return !Objects.equals(this.id, this.getString("_id"));
    }

    public boolean routingChanged() {
        return !Objects.equals(this.routing, this.getString("_routing"));
    }
}

