/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionListenerResponseHandler;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.TaskOperationFailure;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.tasks.BaseTasksRequest;
import org.elasticsearch.action.support.tasks.TransportTasksAction;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.OriginSettingClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.common.util.concurrent.AtomicArray;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.discovery.MasterNotDiscoveredException;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.persistent.PersistentTaskState;
import org.elasticsearch.persistent.PersistentTasksClusterService;
import org.elasticsearch.persistent.PersistentTasksCustomMetadata;
import org.elasticsearch.persistent.PersistentTasksService;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportResponseHandler;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ml.MlTasks;
import org.elasticsearch.xpack.core.ml.action.StartDatafeedAction;
import org.elasticsearch.xpack.core.ml.action.StopDatafeedAction;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedState;
import org.elasticsearch.xpack.core.ml.job.messages.Messages;
import org.elasticsearch.xpack.core.ml.job.persistence.AnomalyDetectorsIndex;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.ml.MachineLearning;
import org.elasticsearch.xpack.ml.action.TransportStartDatafeedAction;
import org.elasticsearch.xpack.ml.datafeed.persistence.DatafeedConfigProvider;
import org.elasticsearch.xpack.ml.notifications.AnomalyDetectionAuditor;
import org.elasticsearch.xpack.ml.utils.ExceptionCollectionHandling;

public class TransportStopDatafeedAction
extends TransportTasksAction<TransportStartDatafeedAction.DatafeedTask, StopDatafeedAction.Request, StopDatafeedAction.Response, StopDatafeedAction.Response> {
    private static final int MAX_ATTEMPTS = 10;
    private static final Logger logger = LogManager.getLogger(TransportStopDatafeedAction.class);
    private final ThreadPool threadPool;
    private final PersistentTasksService persistentTasksService;
    private final DatafeedConfigProvider datafeedConfigProvider;
    private final AnomalyDetectionAuditor auditor;
    private final OriginSettingClient client;

    @Inject
    public TransportStopDatafeedAction(TransportService transportService, ThreadPool threadPool, ActionFilters actionFilters, ClusterService clusterService, PersistentTasksService persistentTasksService, DatafeedConfigProvider datafeedConfigProvider, AnomalyDetectionAuditor auditor, Client client) {
        super("cluster:admin/xpack/ml/datafeed/stop", clusterService, transportService, actionFilters, StopDatafeedAction.Request::new, StopDatafeedAction.Response::new, (Executor)threadPool.executor("ml_utility"));
        this.threadPool = Objects.requireNonNull(threadPool);
        this.persistentTasksService = Objects.requireNonNull(persistentTasksService);
        this.datafeedConfigProvider = Objects.requireNonNull(datafeedConfigProvider);
        this.auditor = Objects.requireNonNull(auditor);
        this.client = new OriginSettingClient(client, "ml");
    }

    static void sortDatafeedIdsByTaskState(Collection<String> expandedDatafeedIds, PersistentTasksCustomMetadata tasks, List<String> startedDatafeedIds, List<String> stoppingDatafeedIds, List<String> notStoppedDatafeedIds) {
        for (String expandedDatafeedId : expandedDatafeedIds) {
            TransportStopDatafeedAction.addDatafeedTaskIdAccordingToState(expandedDatafeedId, MlTasks.getDatafeedState((String)expandedDatafeedId, (PersistentTasksCustomMetadata)tasks), startedDatafeedIds, stoppingDatafeedIds, notStoppedDatafeedIds);
        }
    }

    private static void addDatafeedTaskIdAccordingToState(String datafeedId, DatafeedState datafeedState, List<String> startedDatafeedIds, List<String> stoppingDatafeedIds, List<String> notStoppedDatafeedIds) {
        switch (datafeedState) {
            case STARTING: 
            case STARTED: {
                startedDatafeedIds.add(datafeedId);
                notStoppedDatafeedIds.add(datafeedId);
                break;
            }
            case STOPPED: {
                break;
            }
            case STOPPING: {
                stoppingDatafeedIds.add(datafeedId);
                notStoppedDatafeedIds.add(datafeedId);
                break;
            }
            default: {
                assert (false) : "Unexpected datafeed state " + String.valueOf(datafeedState);
                break;
            }
        }
    }

    protected void doExecute(Task task, StopDatafeedAction.Request request, ActionListener<StopDatafeedAction.Response> listener) {
        this.doExecute(task, request, listener, 1);
    }

    private void doExecute(Task task, StopDatafeedAction.Request request, ActionListener<StopDatafeedAction.Response> listener, int attempt) {
        ClusterState state = this.clusterService.state();
        DiscoveryNodes nodes = state.nodes();
        if (!nodes.isLocalNodeElectedMaster()) {
            if (nodes.getMasterNode() == null) {
                listener.onFailure((Exception)new MasterNotDiscoveredException());
            } else {
                this.transportService.sendRequest(nodes.getMasterNode(), this.actionName, (TransportRequest)request, (TransportResponseHandler)new ActionListenerResponseHandler(listener, StopDatafeedAction.Response::new, TransportResponseHandler.TRANSPORT_WORKER));
            }
        } else {
            PersistentTasksCustomMetadata tasks = (PersistentTasksCustomMetadata)state.getMetadata().custom("persistent_tasks");
            this.datafeedConfigProvider.expandDatafeedIds(request.getDatafeedId(), request.allowNoMatch(), tasks, request.isForce(), null, (ActionListener<SortedSet<String>>)ActionListener.wrap(expandedIds -> {
                ArrayList<String> startedDatafeeds = new ArrayList<String>();
                ArrayList<String> stoppingDatafeeds = new ArrayList<String>();
                ArrayList<String> notStoppedDatafeeds = new ArrayList<String>();
                TransportStopDatafeedAction.sortDatafeedIdsByTaskState(expandedIds, tasks, startedDatafeeds, stoppingDatafeeds, notStoppedDatafeeds);
                if (startedDatafeeds.isEmpty() && stoppingDatafeeds.isEmpty()) {
                    listener.onResponse((Object)new StopDatafeedAction.Response(true));
                    return;
                }
                if (request.isForce()) {
                    this.forceStopDatafeed(request, listener, tasks, nodes, notStoppedDatafeeds);
                } else {
                    this.normalStopDatafeed(task, request, listener, tasks, nodes, startedDatafeeds, stoppingDatafeeds, attempt);
                }
            }, arg_0 -> listener.onFailure(arg_0)));
        }
    }

    private void normalStopDatafeed(Task task, StopDatafeedAction.Request request, ActionListener<StopDatafeedAction.Response> listener, PersistentTasksCustomMetadata tasks, DiscoveryNodes nodes, List<String> startedDatafeeds, List<String> stoppingDatafeeds, int attempt) {
        PersistentTasksCustomMetadata.PersistentTask datafeedTask;
        HashSet<String> executorNodes = new HashSet<String>();
        ArrayList<String> startedDatafeedsJobs = new ArrayList<String>();
        ArrayList<String> resolvedStartedDatafeeds = new ArrayList<String>();
        ArrayList<PersistentTasksCustomMetadata.PersistentTask> allDataFeedsToWaitFor = new ArrayList<PersistentTasksCustomMetadata.PersistentTask>();
        for (String datafeedId : startedDatafeeds) {
            datafeedTask = MlTasks.getDatafeedTask((String)datafeedId, (PersistentTasksCustomMetadata)tasks);
            if (datafeedTask == null) {
                String msg = "Requested datafeed [" + datafeedId + "] be stopped, but datafeed's task could not be found.";
                assert (datafeedTask != null) : msg;
                logger.error(msg);
                continue;
            }
            if (!PersistentTasksClusterService.needsReassignment((PersistentTasksCustomMetadata.Assignment)datafeedTask.getAssignment(), (DiscoveryNodes)nodes)) {
                startedDatafeedsJobs.add(((StartDatafeedAction.DatafeedParams)datafeedTask.getParams()).getJobId());
                resolvedStartedDatafeeds.add(datafeedId);
                executorNodes.add(datafeedTask.getExecutorNode());
                allDataFeedsToWaitFor.add(datafeedTask);
                continue;
            }
            this.persistentTasksService.sendRemoveRequest(datafeedTask.getId(), MachineLearning.HARD_CODED_MACHINE_LEARNING_MASTER_NODE_TIMEOUT, ActionListener.wrap(r -> this.auditDatafeedStopped(datafeedTask), e -> logger.error("[" + datafeedId + "] failed to remove task to stop unassigned datafeed", (Throwable)e)));
            allDataFeedsToWaitFor.add(datafeedTask);
        }
        for (String datafeedId : stoppingDatafeeds) {
            datafeedTask = MlTasks.getDatafeedTask((String)datafeedId, (PersistentTasksCustomMetadata)tasks);
            assert (datafeedTask != null) : "Requested datafeed [" + datafeedId + "] be stopped, but datafeed's task could not be found.";
            allDataFeedsToWaitFor.add(datafeedTask);
        }
        request.setResolvedStartedDatafeedIds(resolvedStartedDatafeeds.toArray(new String[0]));
        request.setNodes(executorNodes.toArray(new String[0]));
        Set movedDatafeeds = ConcurrentCollections.newConcurrentSet();
        ActionListener finalListener = ActionListener.wrap(response -> this.waitForDatafeedStopped((List<PersistentTasksCustomMetadata.PersistentTask<?>>)allDataFeedsToWaitFor, request, (StopDatafeedAction.Response)response, (ActionListener<StopDatafeedAction.Response>)ActionListener.wrap(finished -> {
            for (String datafeedId : movedDatafeeds) {
                PersistentTasksCustomMetadata.PersistentTask datafeedTask = MlTasks.getDatafeedTask((String)datafeedId, (PersistentTasksCustomMetadata)tasks);
                this.persistentTasksService.sendRemoveRequest(datafeedTask.getId(), MachineLearning.HARD_CODED_MACHINE_LEARNING_MASTER_NODE_TIMEOUT, ActionListener.wrap(r -> this.auditDatafeedStopped(datafeedTask), e -> {
                    if (ExceptionsHelper.unwrapCause((Throwable)e) instanceof ResourceNotFoundException) {
                        logger.debug("[{}] relocated datafeed task already removed", (Object)datafeedId);
                    } else {
                        logger.error("[" + datafeedId + "] failed to remove task to stop relocated datafeed", (Throwable)e);
                    }
                }));
            }
            if (startedDatafeedsJobs.isEmpty()) {
                listener.onResponse(finished);
                return;
            }
            this.client.admin().indices().prepareRefresh((String[])startedDatafeedsJobs.stream().map(AnomalyDetectorsIndex::jobResultsAliasedName).toArray(String[]::new)).execute(ActionListener.wrap(_unused -> listener.onResponse(finished), ex -> {
                logger.warn(() -> Strings.format((String)"failed to refresh job [%s] results indices when stopping datafeeds [%s]", (Object[])new Object[]{startedDatafeedsJobs, startedDatafeeds}), (Throwable)ex);
                listener.onResponse(finished);
            }));
        }, arg_0 -> ((ActionListener)listener).onFailure(arg_0)), movedDatafeeds), e -> {
            Throwable unwrapped = ExceptionsHelper.unwrapCause((Throwable)e);
            if (unwrapped instanceof FailedNodeException) {
                if (attempt <= 10) {
                    logger.warn("Node [{}] failed while processing stop datafeed request - retrying", (Object)((FailedNodeException)unwrapped).nodeId());
                    this.doExecute(task, request, listener, attempt + 1);
                } else {
                    listener.onFailure(e);
                }
            } else if (unwrapped instanceof RetryStopDatafeedException) {
                if (attempt <= 10) {
                    logger.info("Insufficient responses while processing stop datafeed request [{}] - retrying", (Object)unwrapped.getMessage());
                    this.threadPool.schedule(() -> this.doExecute(task, request, listener, attempt + 1), TimeValue.timeValueMillis((long)(100L * (long)attempt)), (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
                } else {
                    listener.onFailure((Exception)((Object)ExceptionsHelper.serverError((String)("Failed to stop datafeed [" + request.getDatafeedId() + "] after 10 due to inconsistencies between local and persistent tasks within the cluster"))));
                }
            } else {
                listener.onFailure(e);
            }
        });
        super.doExecute(task, (BaseTasksRequest)request, finalListener);
    }

    private void auditDatafeedStopped(PersistentTasksCustomMetadata.PersistentTask<?> datafeedTask) {
        String jobId = ((StartDatafeedAction.DatafeedParams)datafeedTask.getParams()).getJobId();
        this.auditor.info(jobId, Messages.getMessage((String)"Datafeed stopped"));
    }

    private void forceStopDatafeed(StopDatafeedAction.Request request, ActionListener<StopDatafeedAction.Response> listener, PersistentTasksCustomMetadata tasks, DiscoveryNodes nodes, List<String> notStoppedDatafeeds) {
        AtomicInteger counter = new AtomicInteger();
        AtomicArray failures = new AtomicArray(notStoppedDatafeeds.size());
        for (String datafeedId : notStoppedDatafeeds) {
            PersistentTasksCustomMetadata.PersistentTask datafeedTask = MlTasks.getDatafeedTask((String)datafeedId, (PersistentTasksCustomMetadata)tasks);
            if (datafeedTask != null) {
                this.persistentTasksService.sendRemoveRequest(datafeedTask.getId(), MachineLearning.HARD_CODED_MACHINE_LEARNING_MASTER_NODE_TIMEOUT, ActionListener.wrap(persistentTask -> {
                    if (PersistentTasksClusterService.needsReassignment((PersistentTasksCustomMetadata.Assignment)datafeedTask.getAssignment(), (DiscoveryNodes)nodes)) {
                        this.auditDatafeedStopped(datafeedTask);
                    }
                    if (counter.incrementAndGet() == notStoppedDatafeeds.size()) {
                        TransportStopDatafeedAction.sendResponseOrFailure(request.getDatafeedId(), listener, (AtomicArray<Exception>)failures);
                    }
                }, e -> {
                    int slot = counter.incrementAndGet();
                    if (!(ExceptionsHelper.unwrapCause((Throwable)e) instanceof ResourceNotFoundException)) {
                        failures.set(slot - 1, e);
                    }
                    if (slot == notStoppedDatafeeds.size()) {
                        TransportStopDatafeedAction.sendResponseOrFailure(request.getDatafeedId(), listener, (AtomicArray<Exception>)failures);
                    }
                }));
                continue;
            }
            String msg = "Requested datafeed [" + datafeedId + "] be force-stopped, but datafeed's task could not be found.";
            assert (datafeedTask != null) : msg;
            logger.error(msg);
            int slot = counter.incrementAndGet();
            failures.set(slot - 1, (Object)new RuntimeException(msg));
            if (slot != notStoppedDatafeeds.size()) continue;
            TransportStopDatafeedAction.sendResponseOrFailure(request.getDatafeedId(), listener, (AtomicArray<Exception>)failures);
        }
    }

    protected void taskOperation(CancellableTask actionTask, final StopDatafeedAction.Request request, final TransportStartDatafeedAction.DatafeedTask datafeedTask, final ActionListener<StopDatafeedAction.Response> listener) {
        DatafeedState taskState = DatafeedState.STOPPING;
        datafeedTask.updatePersistentTaskState((PersistentTaskState)taskState, ActionListener.wrap(task -> this.threadPool.executor("ml_utility").execute((Runnable)new AbstractRunnable(){

            public void onFailure(Exception e) {
                if (ExceptionsHelper.unwrapCause((Throwable)e) instanceof ResourceNotFoundException) {
                    listener.onResponse((Object)new StopDatafeedAction.Response(true));
                } else {
                    listener.onFailure(e);
                }
            }

            protected void doRun() {
                datafeedTask.stop("stop_datafeed (api)", request.getStopTimeout());
                listener.onResponse((Object)new StopDatafeedAction.Response(true));
            }
        }), e -> {
            if (ExceptionsHelper.unwrapCause((Throwable)e) instanceof ResourceNotFoundException) {
                listener.onResponse((Object)new StopDatafeedAction.Response(true));
            } else {
                listener.onFailure(e);
            }
        }));
    }

    private static void sendResponseOrFailure(String datafeedId, ActionListener<StopDatafeedAction.Response> listener, AtomicArray<Exception> failures) {
        List caughtExceptions = failures.asList();
        if (caughtExceptions.isEmpty()) {
            listener.onResponse((Object)new StopDatafeedAction.Response(true));
            return;
        }
        String msg = "Failed to stop datafeed [" + datafeedId + "] with [" + caughtExceptions.size() + "] failures, rethrowing first. All Exceptions: [" + caughtExceptions.stream().map(Throwable::getMessage).collect(Collectors.joining(", ")) + "]";
        ElasticsearchStatusException e = ExceptionCollectionHandling.exceptionArrayToStatusException(failures, msg);
        listener.onFailure((Exception)e);
    }

    void waitForDatafeedStopped(List<PersistentTasksCustomMetadata.PersistentTask<?>> datafeedPersistentTasks, StopDatafeedAction.Request request, StopDatafeedAction.Response response, ActionListener<StopDatafeedAction.Response> listener, Set<String> movedDatafeeds) {
        this.persistentTasksService.waitForPersistentTasksCondition(persistentTasksCustomMetadata -> {
            for (PersistentTasksCustomMetadata.PersistentTask originalPersistentTask : datafeedPersistentTasks) {
                String originalPersistentTaskId = originalPersistentTask.getId();
                PersistentTasksCustomMetadata.PersistentTask currentPersistentTask = persistentTasksCustomMetadata.getTask(originalPersistentTaskId);
                if (currentPersistentTask == null) continue;
                if (Objects.equals(originalPersistentTask.getExecutorNode(), currentPersistentTask.getExecutorNode()) && originalPersistentTask.getAllocationId() == currentPersistentTask.getAllocationId()) {
                    return false;
                }
                StartDatafeedAction.DatafeedParams params = (StartDatafeedAction.DatafeedParams)originalPersistentTask.getParams();
                if (!movedDatafeeds.add(params.getDatafeedId())) continue;
                logger.info("Datafeed [{}] changed assignment while waiting for it to be stopped", (Object)params.getDatafeedId());
            }
            return true;
        }, request.getTimeout(), listener.safeMap(result -> response));
    }

    protected StopDatafeedAction.Response newResponse(StopDatafeedAction.Request request, List<StopDatafeedAction.Response> tasks, List<TaskOperationFailure> taskOperationFailures, List<FailedNodeException> failedNodeExceptions) {
        if (request.getResolvedStartedDatafeedIds().length != tasks.size()) {
            if (!taskOperationFailures.isEmpty()) {
                throw ExceptionsHelper.taskOperationFailureToStatusException((TaskOperationFailure)taskOperationFailures.get(0));
            }
            if (!failedNodeExceptions.isEmpty()) {
                throw failedNodeExceptions.get(0);
            }
            throw new RetryStopDatafeedException(request.getResolvedStartedDatafeedIds().length, tasks.size());
        }
        return new StopDatafeedAction.Response(tasks.stream().allMatch(StopDatafeedAction.Response::isStopped));
    }

    static class RetryStopDatafeedException
    extends RuntimeException {
        RetryStopDatafeedException(int numResponsesExpected, int numResponsesReceived) {
            super("expected " + numResponsesExpected + " responses, got " + numResponsesReceived);
        }
    }
}

