/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.task.iterative;

import java.util.List;
import org.ojalgo.RecoverableCondition;
import org.ojalgo.equation.Equation;
import org.ojalgo.function.constant.PrimitiveMath;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.task.iterative.IterativeSolverTask;
import org.ojalgo.matrix.task.iterative.StationaryIterativeSolver;
import org.ojalgo.structure.Access2D;
import org.ojalgo.type.context.NumberContext;

public final class GaussSeidelSolver
extends StationaryIterativeSolver
implements IterativeSolverTask.SparseDelegate {
    @Override
    public double resolve(List<Equation> equations, PhysicalStore<Double> solution) {
        double tmpNormErr = Double.POSITIVE_INFINITY;
        double tmpNormRHS = PrimitiveMath.ZERO;
        int tmpCountRows = equations.size();
        for (int r = 0; r < tmpCountRows; ++r) {
            tmpNormRHS = PrimitiveMath.HYPOT.invoke(tmpNormRHS, equations.get(r).getRHS());
        }
        int tmpIterations = 0;
        int tmpLimit = this.getIterationsLimit();
        NumberContext tmpCntxt = this.getAccuracyContext();
        double tmpRelaxationFactor = this.getRelaxationFactor();
        do {
            tmpNormErr = PrimitiveMath.ZERO;
            for (int r = 0; r < tmpCountRows; ++r) {
                tmpNormErr = PrimitiveMath.HYPOT.invoke(tmpNormErr, equations.get(r).adjust(solution, tmpRelaxationFactor));
            }
            ++tmpIterations;
            if (!this.isDebugPrinterSet()) continue;
            this.debug(tmpIterations, tmpNormErr / tmpNormRHS, solution);
        } while (tmpIterations < tmpLimit && !tmpCntxt.isSmall(tmpNormRHS, tmpNormErr));
        return tmpNormErr / tmpNormRHS;
    }

    @Override
    public MatrixStore<Double> solve(Access2D<?> body, Access2D<?> rhs, PhysicalStore<Double> current) throws RecoverableCondition {
        List<Equation> equations = IterativeSolverTask.toListOfRows(body, rhs);
        this.resolve(equations, current);
        return current;
    }
}

