/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.function.special;

import java.math.BigDecimal;
import java.math.MathContext;
import org.ojalgo.function.constant.PrimitiveMath;

public abstract class MissingMath {
    public static double acosh(double arg) {
        return Math.log(arg + Math.sqrt(arg * arg - 1.0));
    }

    public static double asinh(double arg) {
        return Math.log(arg + Math.sqrt(arg * arg + 1.0));
    }

    public static double atan2(double y, double x) {
        if (y == 0.0 && x == 0.0) {
            return 0.0;
        }
        double ay = Math.abs(y);
        double ax = Math.abs(x);
        double a = Math.min(ay, ax) / Math.max(ay, ax);
        double s = a * a;
        double retVal = ((-0.0464964749 * s + 0.15931422) * s - 0.327622764) * s * a + a;
        if (ay > ax) {
            retVal = 1.570796326794897 - retVal;
        }
        if (x < 0.0) {
            retVal = Math.PI - retVal;
        }
        if (y < 0.0) {
            retVal = -retVal;
        }
        return retVal;
    }

    public static double atanh(double arg) {
        return Math.log((1.0 + arg) / (1.0 - arg)) / 2.0;
    }

    public static BigDecimal divide(BigDecimal numerator, BigDecimal denominator) {
        return numerator.divide(denominator, MathContext.DECIMAL128);
    }

    public static double factorial(int arg) {
        if (arg < 0) {
            throw new IllegalArgumentException();
        }
        if (arg < 2) {
            return PrimitiveMath.ONE;
        }
        if (arg < 13) {
            return MissingMath.factorialInt(arg);
        }
        if (arg < 21) {
            return MissingMath.factorialLong(arg);
        }
        return MissingMath.factorialDouble(arg);
    }

    public static int gcd(int val1, int val2) {
        int retVal = 1;
        int abs1 = Math.abs(val1);
        int abs2 = Math.abs(val2);
        int tmpMax = Math.max(abs1, abs2);
        int tmpMin = Math.min(abs1, abs2);
        while (tmpMin != 0) {
            retVal = tmpMin;
            tmpMin = tmpMax % tmpMin;
            tmpMax = retVal;
        }
        return retVal;
    }

    public static int gcd(int val1, int ... vals) {
        int retVal = val1;
        if (retVal == 1) {
            return 1;
        }
        for (int i = 0; i < vals.length; ++i) {
            if ((retVal = MissingMath.gcd(retVal, vals[i])) != 1) continue;
            return 1;
        }
        return retVal;
    }

    public static int gcd(int[] vals) {
        return MissingMath.gcd(vals[0], vals);
    }

    public static long gcd(long val1, long ... vals) {
        long retVal = val1;
        if (retVal == 1L) {
            return 1L;
        }
        for (int i = 0; i < vals.length; ++i) {
            if ((retVal = MissingMath.gcd(retVal, vals[i])) != 1L) continue;
            return 1L;
        }
        return retVal;
    }

    public static long gcd(long val1, long val2) {
        long retVal = 1L;
        long abs1 = Math.abs(val1);
        long abs2 = Math.abs(val2);
        long tmpMax = Math.max(abs1, abs2);
        long tmpMin = Math.min(abs1, abs2);
        while (tmpMin != 0L) {
            retVal = tmpMin;
            tmpMin = tmpMax % tmpMin;
            tmpMax = retVal;
        }
        return retVal;
    }

    public static long gcd(long[] vals) {
        return MissingMath.gcd(vals[0], vals);
    }

    public static BigDecimal hypot(BigDecimal arg1, BigDecimal arg2) {
        BigDecimal prod1 = arg1.multiply(arg1);
        BigDecimal prod2 = arg2.multiply(arg2);
        return MissingMath.root(prod1.add(prod2), 2);
    }

    public static double hypot(double arg1, double arg2) {
        if (Double.isNaN(arg1) || Double.isNaN(arg2)) {
            return Double.NaN;
        }
        double abs1 = Math.abs(arg1);
        double abs2 = Math.abs(arg2);
        double retVal = 0.0;
        if (abs1 > abs2) {
            retVal = abs1 * MissingMath.sqrt1px2(abs2 / abs1);
        } else if (abs2 > 0.0) {
            retVal = abs2 * MissingMath.sqrt1px2(abs1 / abs2);
        }
        return retVal;
    }

    public static double log10(double arg, double replacement) {
        if (Math.abs(arg) < Double.MIN_NORMAL) {
            return replacement;
        }
        return Math.log10(arg);
    }

    public static double logistic(double arg) {
        return 1.0 / (1.0 + Math.exp(-arg));
    }

    public static double logit(double arg) {
        return Math.log(1.0 / (1.0 - arg));
    }

    public static double max(double ... values) {
        double retVal = values[0];
        int i = values.length;
        while (i-- != 1) {
            retVal = values[i] > retVal ? values[i] : retVal;
        }
        return retVal;
    }

    public static double max(double a, double b) {
        return Math.max(a, b);
    }

    public static double max(double a, double b, double c) {
        return Math.max(Math.max(a, b), c);
    }

    public static double max(double a, double b, double c, double d) {
        return Math.max(Math.max(a, b), Math.max(c, d));
    }

    public static int max(int ... values) {
        int retVal = values[0];
        int i = values.length;
        while (i-- != 1) {
            retVal = values[i] > retVal ? values[i] : retVal;
        }
        return retVal;
    }

    public static int max(int a, int b) {
        return Math.max(a, b);
    }

    public static int max(int a, int b, int c) {
        return Math.max(Math.max(a, b), c);
    }

    public static int max(int a, int b, int c, int d) {
        return Math.max(Math.max(a, b), Math.max(c, d));
    }

    public static long max(long ... values) {
        long retVal = values[0];
        int i = values.length;
        while (i-- != 1) {
            retVal = values[i] > retVal ? values[i] : retVal;
        }
        return retVal;
    }

    public static long max(long a, long b) {
        return Math.max(a, b);
    }

    public static long max(long a, long b, long c) {
        return Math.max(Math.max(a, b), c);
    }

    public static long max(long a, long b, long c, long d) {
        return Math.max(Math.max(a, b), Math.max(c, d));
    }

    public static double min(double ... values) {
        double retVal = values[0];
        int i = values.length;
        while (i-- != 1) {
            retVal = values[i] < retVal ? values[i] : retVal;
        }
        return retVal;
    }

    public static double min(double a, double b) {
        return Math.min(a, b);
    }

    public static double min(double a, double b, double c) {
        return Math.min(Math.min(a, b), c);
    }

    public static double min(double a, double b, double c, double d) {
        return Math.min(Math.min(a, b), Math.min(c, d));
    }

    public static int min(int ... values) {
        int retVal = values[0];
        int i = values.length;
        while (i-- != 1) {
            retVal = values[i] < retVal ? values[i] : retVal;
        }
        return retVal;
    }

    public static int min(int a, int b) {
        return Math.min(a, b);
    }

    public static int min(int a, int b, int c) {
        return Math.min(Math.min(a, b), c);
    }

    public static int min(int a, int b, int c, int d) {
        return Math.min(Math.min(a, b), Math.min(c, d));
    }

    public static long min(long ... values) {
        long retVal = values[0];
        int i = values.length;
        while (i-- != 1) {
            retVal = values[i] < retVal ? values[i] : retVal;
        }
        return retVal;
    }

    public static long min(long a, long b) {
        return Math.min(a, b);
    }

    public static long min(long a, long b, long c) {
        return Math.min(Math.min(a, b), c);
    }

    public static long min(long a, long b, long c, long d) {
        return Math.min(Math.min(a, b), Math.min(c, d));
    }

    public static double norm(double ... values) {
        double retVal = Math.abs(values[0]);
        int i = values.length;
        while (i-- != 1) {
            retVal = values[i] > retVal ? Math.abs(values[i]) : retVal;
        }
        return retVal;
    }

    public static double norm(double a, double b) {
        return Math.max(Math.abs(a), Math.abs(b));
    }

    public static double norm(double a, double b, double c) {
        return Math.max(Math.max(Math.abs(a), Math.abs(b)), Math.abs(c));
    }

    public static double norm(double a, double b, double c, double d) {
        return Math.max(Math.max(Math.abs(a), Math.abs(b)), Math.max(Math.abs(c), Math.abs(d)));
    }

    public static BigDecimal pow(BigDecimal arg1, BigDecimal arg2) {
        if (arg2.signum() == 0) {
            return BigDecimal.ONE;
        }
        if (arg1.signum() == 0) {
            return BigDecimal.ZERO;
        }
        if (arg2.compareTo(BigDecimal.ONE) == 0) {
            return arg1;
        }
        return BigDecimal.valueOf(Math.pow(arg1.doubleValue(), arg2.doubleValue()));
    }

    public static BigDecimal power(BigDecimal arg, int param) {
        switch (param) {
            case 0: {
                return BigDecimal.ONE;
            }
            case 1: {
                return arg;
            }
            case 2: {
                return arg.multiply(arg, MathContext.DECIMAL128);
            }
            case 3: {
                return arg.multiply(arg).multiply(arg, MathContext.DECIMAL128);
            }
            case 4: {
                BigDecimal arg2 = arg.multiply(arg);
                return arg2.multiply(arg2, MathContext.DECIMAL128);
            }
        }
        return arg.pow(param, MathContext.DECIMAL128);
    }

    public static double power(double arg, int param) {
        if (param < 0) {
            return 1.0 / MissingMath.power(arg, -param);
        }
        double retVal = 1.0;
        while (param > 0) {
            retVal *= arg;
            --param;
        }
        return retVal;
    }

    public static long power(long arg, int param) {
        if (param == 0) {
            return 1L;
        }
        if (param == 1) {
            return arg;
        }
        if (param == 2) {
            return arg * arg;
        }
        if (param < 0) {
            return Math.round(Math.pow(arg, param));
        }
        long retVal = arg;
        for (int p = 1; p < param; ++p) {
            retVal *= arg;
        }
        return retVal;
    }

    public static BigDecimal root(BigDecimal arg, int param) {
        BigDecimal shouldBeZero;
        if (param <= 0) {
            throw new IllegalArgumentException();
        }
        if (param == 1) {
            return arg;
        }
        BigDecimal bigArg = arg.round(MathContext.DECIMAL128);
        BigDecimal bigParam = BigDecimal.valueOf(param);
        BigDecimal retVal = BigDecimal.ZERO;
        double primArg = bigArg.doubleValue();
        if (!Double.isInfinite(primArg) && !Double.isNaN(primArg)) {
            retVal = BigDecimal.valueOf(Math.pow(primArg, 1.0 / (double)param));
        }
        while ((shouldBeZero = MissingMath.power(retVal, param).subtract(bigArg)).signum() != 0) {
            retVal = retVal.subtract(shouldBeZero.divide(bigParam.multiply(retVal.pow(param - 1)), MathContext.DECIMAL128));
        }
        return retVal;
    }

    public static double root(double arg, int param) {
        if (param != 0) {
            return Math.pow(arg, 1.0 / (double)param);
        }
        throw new IllegalArgumentException();
    }

    public static int roundToInt(double value) {
        return Math.toIntExact(Math.round(value));
    }

    public static double scale(double arg, int param) {
        if (param == 0) {
            return 1.0;
        }
        if (param < 0) {
            int factor = 1;
            while (param < 0) {
                factor *= 10;
                ++param;
            }
            return Math.rint((double)factor / arg) * (double)factor;
        }
        int factor = 1;
        while (param > 0) {
            factor *= 10;
            --param;
        }
        return Math.rint((double)factor * arg) / (double)factor;
    }

    public static BigDecimal signum(BigDecimal arg) {
        switch (arg.signum()) {
            case 1: {
                return BigDecimal.ONE;
            }
            case -1: {
                return BigDecimal.ONE.negate();
            }
        }
        return BigDecimal.ZERO;
    }

    public static double sqrt1px2(double arg) {
        return Math.sqrt(1.0 + arg * arg);
    }

    public static int toMinIntExact(long ... values) {
        return Math.toIntExact(MissingMath.min(values));
    }

    public static int toMinIntExact(long a, long b) {
        return Math.toIntExact(Math.min(a, b));
    }

    public static int toMinIntExact(long a, long b, long c) {
        return Math.toIntExact(MissingMath.min(a, b, c));
    }

    public static int toMinIntExact(long a, long b, long c, long d) {
        return Math.toIntExact(MissingMath.min(a, b, c, d));
    }

    static double factorialDouble(int arg) {
        double retVal = PrimitiveMath.ONE;
        for (int i = 2; i <= arg; ++i) {
            retVal *= (double)i;
        }
        return retVal;
    }

    static int factorialInt(int arg) {
        int retVal = 1;
        for (int i = 2; i <= arg; ++i) {
            retVal *= i;
        }
        return retVal;
    }

    static long factorialLong(int arg) {
        long retVal = 1L;
        for (int i = 2; i <= arg; ++i) {
            retVal *= (long)i;
        }
        return retVal;
    }
}

