/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.deepseek;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.util.LazyInitializable;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.inference.ChunkInferenceInput;
import org.elasticsearch.inference.ChunkedInference;
import org.elasticsearch.inference.InferenceServiceConfiguration;
import org.elasticsearch.inference.InferenceServiceResults;
import org.elasticsearch.inference.InputType;
import org.elasticsearch.inference.Model;
import org.elasticsearch.inference.SettingsConfiguration;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.inference.configuration.SettingsConfigurationFieldType;
import org.elasticsearch.xpack.inference.external.action.ActionUtils;
import org.elasticsearch.xpack.inference.external.action.SenderExecutableAction;
import org.elasticsearch.xpack.inference.external.http.sender.HttpRequestSender;
import org.elasticsearch.xpack.inference.external.http.sender.InferenceInputs;
import org.elasticsearch.xpack.inference.external.http.sender.UnifiedChatInput;
import org.elasticsearch.xpack.inference.services.SenderService;
import org.elasticsearch.xpack.inference.services.ServiceComponents;
import org.elasticsearch.xpack.inference.services.ServiceUtils;
import org.elasticsearch.xpack.inference.services.deepseek.DeepSeekChatCompletionModel;
import org.elasticsearch.xpack.inference.services.deepseek.DeepSeekRequestManager;
import org.elasticsearch.xpack.inference.services.settings.DefaultSecretSettings;

public class DeepSeekService
extends SenderService {
    private static final String NAME = "deepseek";
    private static final String CHAT_COMPLETION_ERROR_PREFIX = "deepseek chat completions";
    private static final String COMPLETION_ERROR_PREFIX = "deepseek completions";
    private static final String SERVICE_NAME = "DeepSeek";
    private static final EnumSet<TaskType> SUPPORTED_TASK_TYPES_FOR_SERVICES_API = EnumSet.of(TaskType.COMPLETION, TaskType.CHAT_COMPLETION);
    private static final EnumSet<TaskType> SUPPORTED_TASK_TYPES_FOR_STREAMING = EnumSet.of(TaskType.COMPLETION, TaskType.CHAT_COMPLETION);
    private static final TransportVersion ML_INFERENCE_DEEPSEEK = TransportVersion.fromName((String)"ml_inference_deepseek");

    public DeepSeekService(HttpRequestSender.Factory factory, ServiceComponents serviceComponents) {
        super(factory, serviceComponents);
    }

    @Override
    protected void doInfer(Model model, InferenceInputs inputs, Map<String, Object> taskSettings, TimeValue timeout, ActionListener<InferenceServiceResults> listener) {
        this.doInfer(model, inputs, timeout, COMPLETION_ERROR_PREFIX, listener);
    }

    private void doInfer(Model model, InferenceInputs inputs, TimeValue timeout, String errorPrefix, ActionListener<InferenceServiceResults> listener) {
        if (model instanceof DeepSeekChatCompletionModel) {
            DeepSeekChatCompletionModel deepSeekModel = (DeepSeekChatCompletionModel)model;
            DeepSeekRequestManager requestCreator = new DeepSeekRequestManager(deepSeekModel, this.getServiceComponents().threadPool());
            String errorMessage = ActionUtils.constructFailedToSendRequestMessage(errorPrefix);
            SenderExecutableAction action = new SenderExecutableAction(this.getSender(), requestCreator, errorMessage);
            action.execute(inputs, timeout, listener);
        } else {
            listener.onFailure((Exception)((Object)ServiceUtils.createInvalidModelException(model)));
        }
    }

    @Override
    protected void validateInputType(InputType inputType, Model model, ValidationException validationException) {
    }

    @Override
    protected void doUnifiedCompletionInfer(Model model, UnifiedChatInput inputs, TimeValue timeout, ActionListener<InferenceServiceResults> listener) {
        this.doInfer(model, (InferenceInputs)inputs, timeout, CHAT_COMPLETION_ERROR_PREFIX, listener);
    }

    @Override
    protected void doChunkedInfer(Model model, List<ChunkInferenceInput> inputs, Map<String, Object> taskSettings, InputType inputType, TimeValue timeout, ActionListener<List<ChunkedInference>> listener) {
        listener.onFailure((Exception)new UnsupportedOperationException(Strings.format((String)"The %s service only supports unified completion", (Object[])new Object[]{NAME})));
    }

    public String name() {
        return NAME;
    }

    public void parseRequestConfig(String modelId, TaskType taskType, Map<String, Object> config, ActionListener<Model> parsedModelListener) {
        ActionListener.completeWith(parsedModelListener, () -> {
            Map<String, Object> serviceSettingsMap = ServiceUtils.removeFromMapOrThrowIfNull(config, "service_settings");
            try {
                DeepSeekChatCompletionModel deepSeekChatCompletionModel = DeepSeekChatCompletionModel.createFromNewInput(modelId, taskType, NAME, serviceSettingsMap);
                return deepSeekChatCompletionModel;
            }
            finally {
                ServiceUtils.throwIfNotEmptyMap(serviceSettingsMap, NAME);
            }
        });
    }

    public Model parsePersistedConfigWithSecrets(String modelId, TaskType taskType, Map<String, Object> config, Map<String, Object> secrets) {
        Map<String, Object> serviceSettingsMap = ServiceUtils.removeFromMapOrThrowIfNull(config, "service_settings");
        Map<String, Object> secretSettingsMap = ServiceUtils.removeFromMapOrThrowIfNull(secrets, "secret_settings");
        return DeepSeekChatCompletionModel.readFromStorage(modelId, taskType, NAME, serviceSettingsMap, secretSettingsMap);
    }

    public Model parsePersistedConfig(String modelId, TaskType taskType, Map<String, Object> config) {
        Map<String, Object> serviceSettingsMap = ServiceUtils.removeFromMapOrThrowIfNull(config, "service_settings");
        return DeepSeekChatCompletionModel.readFromStorage(modelId, taskType, NAME, serviceSettingsMap, null);
    }

    public InferenceServiceConfiguration getConfiguration() {
        return Configuration.get();
    }

    public EnumSet<TaskType> supportedTaskTypes() {
        return SUPPORTED_TASK_TYPES_FOR_SERVICES_API;
    }

    public TransportVersion getMinimalSupportedVersion() {
        return ML_INFERENCE_DEEPSEEK;
    }

    public Set<TaskType> supportedStreamingTasks() {
        return SUPPORTED_TASK_TYPES_FOR_STREAMING;
    }

    private static class Configuration {
        private static final LazyInitializable<InferenceServiceConfiguration, RuntimeException> configuration = new LazyInitializable(() -> {
            HashMap<String, SettingsConfiguration> configurationMap = new HashMap<String, SettingsConfiguration>();
            configurationMap.put("model_id", new SettingsConfiguration.Builder(SUPPORTED_TASK_TYPES_FOR_SERVICES_API).setDescription("The name of the model to use for the inference task.").setLabel("Model ID").setRequired(Boolean.valueOf(true)).setSensitive(Boolean.valueOf(false)).setUpdatable(Boolean.valueOf(false)).setType(SettingsConfigurationFieldType.STRING).build());
            configurationMap.putAll(DefaultSecretSettings.toSettingsConfigurationWithDescription("The DeepSeek API authentication key. For more details about generating DeepSeek API keys, refer to https://api-docs.deepseek.com.", SUPPORTED_TASK_TYPES_FOR_SERVICES_API));
            configurationMap.put("url", new SettingsConfiguration.Builder(SUPPORTED_TASK_TYPES_FOR_SERVICES_API).setDefaultValue((Object)"https://api.deepseek.com/chat/completions").setDescription("The URL endpoint to use for the requests.").setLabel("URL").setRequired(Boolean.valueOf(false)).setSensitive(Boolean.valueOf(false)).setUpdatable(Boolean.valueOf(false)).setType(SettingsConfigurationFieldType.STRING).build());
            return new InferenceServiceConfiguration.Builder().setService(DeepSeekService.NAME).setName(DeepSeekService.SERVICE_NAME).setTaskTypes(SUPPORTED_TASK_TYPES_FOR_SERVICES_API).setConfigurations(configurationMap).build();
        });

        private Configuration() {
        }

        public static InferenceServiceConfiguration get() {
            return (InferenceServiceConfiguration)configuration.getOrCompute();
        }
    }
}

