/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.http.sender;

import java.util.Objects;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.inference.external.http.sender.RequestManager;
import org.elasticsearch.xpack.inference.services.RateLimitGroupingModel;
import org.elasticsearch.xpack.inference.services.settings.RateLimitSettings;

public abstract class BaseRequestManager
implements RequestManager {
    private final ThreadPool threadPool;
    private final String inferenceEntityId;
    private final EndpointGrouping endpointGrouping;
    private final RateLimitSettings rateLimitSettings;

    public BaseRequestManager(ThreadPool threadPool, String inferenceEntityId, Object rateLimitGroup, RateLimitSettings rateLimitSettings) {
        this.threadPool = Objects.requireNonNull(threadPool);
        this.inferenceEntityId = Objects.requireNonNull(inferenceEntityId);
        Objects.requireNonNull(rateLimitSettings);
        this.endpointGrouping = new EndpointGrouping(Objects.requireNonNull(rateLimitGroup).hashCode(), rateLimitSettings);
        this.rateLimitSettings = rateLimitSettings;
    }

    public BaseRequestManager(ThreadPool threadPool, RateLimitGroupingModel rateLimitGroupingModel) {
        this.threadPool = Objects.requireNonNull(threadPool);
        Objects.requireNonNull(rateLimitGroupingModel);
        this.inferenceEntityId = rateLimitGroupingModel.inferenceEntityId();
        this.endpointGrouping = new EndpointGrouping(rateLimitGroupingModel.rateLimitGroupingHash(), rateLimitGroupingModel.rateLimitSettings());
        this.rateLimitSettings = rateLimitGroupingModel.rateLimitSettings();
    }

    protected void execute(Runnable runnable) {
        this.threadPool.executor("inference_utility").execute(runnable);
    }

    @Override
    public String inferenceEntityId() {
        return this.inferenceEntityId;
    }

    @Override
    public Object rateLimitGrouping() {
        return this.endpointGrouping;
    }

    @Override
    public RateLimitSettings rateLimitSettings() {
        return this.rateLimitSettings;
    }

    private record EndpointGrouping(int group, RateLimitSettings settings) {
    }
}

