/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.http;

import java.io.Closeable;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.http.nio.conn.NHttpClientConnectionManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.threadpool.Scheduler;
import org.elasticsearch.threadpool.ThreadPool;

public class IdleConnectionEvictor
implements Closeable {
    private static final Logger logger = LogManager.getLogger(IdleConnectionEvictor.class);
    private final ThreadPool threadPool;
    private final NHttpClientConnectionManager connectionManager;
    private final TimeValue sleepTime;
    private final AtomicReference<TimeValue> maxIdleTime = new AtomicReference();
    private final AtomicReference<Scheduler.Cancellable> cancellableTask = new AtomicReference();

    public IdleConnectionEvictor(ThreadPool threadPool, NHttpClientConnectionManager connectionManager, TimeValue sleepTime, @Nullable TimeValue maxIdleTime) {
        this.threadPool = Objects.requireNonNull(threadPool);
        this.connectionManager = Objects.requireNonNull(connectionManager);
        this.sleepTime = Objects.requireNonNull(sleepTime);
        this.maxIdleTime.set(maxIdleTime);
    }

    public void setMaxIdleTime(TimeValue maxIdleTime) {
        this.maxIdleTime.set(maxIdleTime);
    }

    public synchronized void start() {
        if (this.cancellableTask.get() == null) {
            this.startInternal();
        }
    }

    private void startInternal() {
        logger.debug(() -> Strings.format((String)"Idle connection evictor started with wait time: [%s] max idle: [%s]", (Object[])new Object[]{this.sleepTime, this.maxIdleTime}));
        this.cancellableTask.set(this.threadPool.scheduleWithFixedDelay(() -> {
            try {
                this.connectionManager.closeExpiredConnections();
                if (this.maxIdleTime.get() != null) {
                    this.connectionManager.closeIdleConnections(this.maxIdleTime.get().millis(), TimeUnit.MILLISECONDS);
                }
            }
            catch (Exception e) {
                logger.warn("HTTP connection eviction failed", (Throwable)e);
            }
        }, this.sleepTime, (Executor)this.threadPool.executor("inference_utility")));
    }

    @Override
    public void close() {
        if (this.cancellableTask.get() != null) {
            logger.debug("Idle connection evictor closing");
            this.cancellableTask.get().cancel();
        }
    }

    public boolean isRunning() {
        return this.cancellableTask.get() != null && !this.cancellableTask.get().isCancelled();
    }
}

