/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.common;

import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.json.JsonXContent;

public class JsonUtils {
    public static <T> String toJson(T value, String field) {
        try {
            XContentBuilder builder = JsonXContent.contentBuilder();
            if (value instanceof SecureString) {
                SecureString secureString = (SecureString)value;
                builder.value(secureString.toString());
            } else {
                builder.value(value);
            }
            return Strings.toString((XContentBuilder)builder);
        }
        catch (Exception e) {
            throw new IllegalStateException(Strings.format((String)"Failed to serialize value as JSON, field: %s, error: %s", (Object[])new Object[]{field, e.getMessage()}), e);
        }
    }

    private JsonUtils() {
    }
}

