/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.apmdata;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.plugins.ActionPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.xpack.apmdata.APMIndexTemplateRegistry;
import org.elasticsearch.xpack.core.XPackSettings;

public class APMPlugin
extends Plugin
implements ActionPlugin {
    private static final Logger logger = LogManager.getLogger(APMPlugin.class);
    final SetOnce<APMIndexTemplateRegistry> registry = new SetOnce();
    private final boolean enabled;
    static final Setting<Boolean> APM_DATA_REGISTRY_ENABLED = Setting.boolSetting((String)"xpack.apm_data.registry.enabled", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});

    public APMPlugin(Settings settings) {
        this.enabled = (Boolean)XPackSettings.APM_DATA_ENABLED.get(settings);
    }

    public Collection<?> createComponents(Plugin.PluginServices services) {
        logger.info("APM ingest plugin is {}", (Object)(this.enabled ? "enabled" : "disabled"));
        Settings settings = services.environment().settings();
        ClusterService clusterService = services.clusterService();
        this.registry.set((Object)new APMIndexTemplateRegistry(settings, clusterService, services.threadPool(), services.client(), services.xContentRegistry(), services.featureService()));
        if (this.enabled) {
            APMIndexTemplateRegistry registryInstance = (APMIndexTemplateRegistry)((Object)this.registry.get());
            registryInstance.setEnabled((Boolean)APM_DATA_REGISTRY_ENABLED.get(settings));
            registryInstance.initialize();
        }
        return Collections.emptyList();
    }

    public void close() {
        ((APMIndexTemplateRegistry)((Object)this.registry.get())).close();
    }

    public List<Setting<?>> getSettings() {
        return List.of(APM_DATA_REGISTRY_ENABLED);
    }
}

