/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.convert;

import java.net.InetAddress;
import org.apache.lucene.document.InetAddressPoint;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.breaker.CircuitBreaker;
import org.elasticsearch.common.network.InetAddresses;
import org.elasticsearch.compute.operator.BreakingBytesRefBuilder;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.AbstractConvertFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ParseIpLeadingZerosAreDecimalEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ParseIpLeadingZerosAreOctalEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ParseIpLeadingZerosRejectedEvaluator;

public class ParseIp {
    private static final byte[] IPV4_PREFIX = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1};
    static final AbstractConvertFunction.BuildFactory FROM_KEYWORD_LEADING_ZEROS_REJECTED = (source, field) -> new ParseIpLeadingZerosRejectedEvaluator.Factory(source, field, driverContext -> ParseIp.buildScratch(driverContext.breaker()));
    static final AbstractConvertFunction.BuildFactory FROM_KEYWORD_LEADING_ZEROS_DECIMAL = (source, field) -> new ParseIpLeadingZerosAreDecimalEvaluator.Factory(source, field, driverContext -> ParseIp.buildScratch(driverContext.breaker()));
    static final AbstractConvertFunction.BuildFactory FROM_KEYWORD_LEADING_ZEROS_OCTAL = (source, field) -> new ParseIpLeadingZerosAreOctalEvaluator.Factory(source, field, driverContext -> ParseIp.buildScratch(driverContext.breaker()));

    public static BreakingBytesRefBuilder buildScratch(CircuitBreaker breaker) {
        BreakingBytesRefBuilder scratch = new BreakingBytesRefBuilder(breaker, "to_ip", 16);
        scratch.setLength(16);
        return scratch;
    }

    public static BytesRef leadingZerosRejected(BytesRef string, BreakingBytesRefBuilder scratch) {
        int end = string.offset + string.length;
        if (ParseIp.isV6(string, end)) {
            InetAddress inetAddress = InetAddresses.forString((String)string.utf8ToString());
            return new BytesRef(InetAddressPoint.encode((InetAddress)inetAddress));
        }
        System.arraycopy(IPV4_PREFIX, 0, scratch.bytes(), 0, IPV4_PREFIX.length);
        int offset = string.offset;
        for (int dest = IPV4_PREFIX.length; dest < 16; ++dest) {
            if (offset >= end) {
                throw ParseIp.invalid(string);
            }
            if (string.bytes[offset] == 48) {
                if (++offset == end || string.bytes[offset] == 46) {
                    scratch.bytes()[dest] = 0;
                    ++offset;
                    continue;
                }
                throw ParseIp.invalid(string);
            }
            int v = ParseIp.digit(string, offset++);
            while (offset < end && string.bytes[offset] != 46) {
                v = v * 10 + ParseIp.digit(string, offset++);
            }
            ++offset;
            if (v > 255) {
                throw ParseIp.invalid(string);
            }
            scratch.bytes()[dest] = (byte)v;
        }
        return scratch.bytesRefView();
    }

    public static BytesRef leadingZerosAreDecimal(BytesRef string, BreakingBytesRefBuilder scratch) {
        int end = string.offset + string.length;
        if (ParseIp.isV6(string, end)) {
            InetAddress inetAddress = InetAddresses.forString((String)string.utf8ToString());
            return new BytesRef(InetAddressPoint.encode((InetAddress)inetAddress));
        }
        System.arraycopy(IPV4_PREFIX, 0, scratch.bytes(), 0, IPV4_PREFIX.length);
        int offset = string.offset;
        for (int dest = IPV4_PREFIX.length; dest < 16; ++dest) {
            if (offset >= end) {
                throw ParseIp.invalid(string);
            }
            int v = ParseIp.digit(string, offset++);
            while (offset < end && string.bytes[offset] != 46) {
                v = v * 10 + ParseIp.digit(string, offset++);
            }
            ++offset;
            if (v > 255) {
                throw ParseIp.invalid(string);
            }
            scratch.bytes()[dest] = (byte)v;
        }
        return scratch.bytesRefView();
    }

    public static BytesRef leadingZerosAreOctal(BytesRef string, BreakingBytesRefBuilder scratch) {
        int end = string.offset + string.length;
        if (ParseIp.isV6(string, end)) {
            InetAddress inetAddress = InetAddresses.forString((String)string.utf8ToString());
            return new BytesRef(InetAddressPoint.encode((InetAddress)inetAddress));
        }
        System.arraycopy(IPV4_PREFIX, 0, scratch.bytes(), 0, IPV4_PREFIX.length);
        int offset = string.offset;
        for (int dest = IPV4_PREFIX.length; dest < 16; ++dest) {
            int v;
            if (offset >= end) {
                throw ParseIp.invalid(string);
            }
            if (string.bytes[offset] == 48) {
                ++offset;
                v = 0;
                while (offset < end && string.bytes[offset] != 46) {
                    v = v * 8 + ParseIp.octalDigit(string, offset++);
                }
                ++offset;
            } else {
                v = ParseIp.digit(string, offset++);
                while (offset < end && string.bytes[offset] != 46) {
                    v = v * 10 + ParseIp.digit(string, offset++);
                }
                ++offset;
            }
            scratch.bytes()[dest] = (byte)v;
        }
        return scratch.bytesRefView();
    }

    private static int digit(BytesRef string, int offset) {
        if (string.bytes[offset] < 48 || 57 < string.bytes[offset]) {
            throw ParseIp.invalid(string);
        }
        return string.bytes[offset] - 48;
    }

    private static int octalDigit(BytesRef string, int offset) {
        if (string.bytes[offset] < 48 || 55 < string.bytes[offset]) {
            throw ParseIp.invalid(string);
        }
        return string.bytes[offset] - 48;
    }

    private static IllegalArgumentException invalid(BytesRef string) {
        return new IllegalArgumentException("'" + string.utf8ToString() + "' is not an IP string literal.");
    }

    private static boolean isV6(BytesRef string, int end) {
        for (int i = string.offset; i < end; ++i) {
            if (string.bytes[i] != 58) continue;
            return true;
        }
        return false;
    }
}

