/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.azureopenai;

import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.inference.InferenceServiceResults;
import org.elasticsearch.inference.InputType;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.inference.common.Truncator;
import org.elasticsearch.xpack.inference.external.http.retry.RequestSender;
import org.elasticsearch.xpack.inference.external.http.retry.ResponseHandler;
import org.elasticsearch.xpack.inference.external.http.sender.EmbeddingsInput;
import org.elasticsearch.xpack.inference.external.http.sender.ExecutableInferenceRequest;
import org.elasticsearch.xpack.inference.external.http.sender.InferenceInputs;
import org.elasticsearch.xpack.inference.services.azureopenai.AzureOpenAiRequestManager;
import org.elasticsearch.xpack.inference.services.azureopenai.AzureOpenAiResponseHandler;
import org.elasticsearch.xpack.inference.services.azureopenai.embeddings.AzureOpenAiEmbeddingsModel;
import org.elasticsearch.xpack.inference.services.azureopenai.request.AzureOpenAiEmbeddingsRequest;
import org.elasticsearch.xpack.inference.services.openai.response.OpenAiEmbeddingsResponseEntity;

public class AzureOpenAiEmbeddingsRequestManager
extends AzureOpenAiRequestManager {
    private static final Logger logger = LogManager.getLogger(AzureOpenAiEmbeddingsRequestManager.class);
    private static final ResponseHandler HANDLER = AzureOpenAiEmbeddingsRequestManager.createEmbeddingsHandler();
    private final Truncator truncator;
    private final AzureOpenAiEmbeddingsModel model;

    private static ResponseHandler createEmbeddingsHandler() {
        return new AzureOpenAiResponseHandler("azure openai text embedding", OpenAiEmbeddingsResponseEntity::fromResponse, false);
    }

    public static AzureOpenAiEmbeddingsRequestManager of(AzureOpenAiEmbeddingsModel model, Truncator truncator, ThreadPool threadPool) {
        return new AzureOpenAiEmbeddingsRequestManager(Objects.requireNonNull(model), Objects.requireNonNull(truncator), Objects.requireNonNull(threadPool));
    }

    public AzureOpenAiEmbeddingsRequestManager(AzureOpenAiEmbeddingsModel model, Truncator truncator, ThreadPool threadPool) {
        super(threadPool, model);
        this.model = Objects.requireNonNull(model);
        this.truncator = Objects.requireNonNull(truncator);
    }

    @Override
    public void execute(InferenceInputs inferenceInputs, RequestSender requestSender, Supplier<Boolean> hasRequestCompletedFunction, ActionListener<InferenceServiceResults> listener) {
        EmbeddingsInput input = inferenceInputs.castTo(EmbeddingsInput.class);
        List<String> docsInput = input.getInputs();
        InputType inputType = input.getInputType();
        Truncator.TruncationResult truncatedInput = Truncator.truncate(docsInput, this.model.getServiceSettings().maxInputTokens());
        AzureOpenAiEmbeddingsRequest request = new AzureOpenAiEmbeddingsRequest(this.truncator, truncatedInput, inputType, this.model);
        this.execute(new ExecutableInferenceRequest(requestSender, logger, request, HANDLER, hasRequestCompletedFunction, listener));
    }
}

