/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.azureaistudio.embeddings;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.inference.ChunkingSettings;
import org.elasticsearch.inference.ModelConfigurations;
import org.elasticsearch.inference.ModelSecrets;
import org.elasticsearch.inference.SecretSettings;
import org.elasticsearch.inference.ServiceSettings;
import org.elasticsearch.inference.TaskSettings;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.xpack.inference.external.action.ExecutableAction;
import org.elasticsearch.xpack.inference.services.ConfigurationParseContext;
import org.elasticsearch.xpack.inference.services.azureaistudio.AzureAiStudioEndpointType;
import org.elasticsearch.xpack.inference.services.azureaistudio.AzureAiStudioModel;
import org.elasticsearch.xpack.inference.services.azureaistudio.AzureAiStudioProvider;
import org.elasticsearch.xpack.inference.services.azureaistudio.action.AzureAiStudioActionVisitor;
import org.elasticsearch.xpack.inference.services.azureaistudio.embeddings.AzureAiStudioEmbeddingsRequestTaskSettings;
import org.elasticsearch.xpack.inference.services.azureaistudio.embeddings.AzureAiStudioEmbeddingsServiceSettings;
import org.elasticsearch.xpack.inference.services.azureaistudio.embeddings.AzureAiStudioEmbeddingsTaskSettings;
import org.elasticsearch.xpack.inference.services.settings.DefaultSecretSettings;

public class AzureAiStudioEmbeddingsModel
extends AzureAiStudioModel {
    public static AzureAiStudioEmbeddingsModel of(AzureAiStudioEmbeddingsModel model, Map<String, Object> taskSettings) {
        if (taskSettings == null || taskSettings.isEmpty()) {
            return model;
        }
        AzureAiStudioEmbeddingsRequestTaskSettings requestTaskSettings = AzureAiStudioEmbeddingsRequestTaskSettings.fromMap(taskSettings);
        AzureAiStudioEmbeddingsTaskSettings taskSettingToUse = AzureAiStudioEmbeddingsTaskSettings.of(model.getTaskSettings(), requestTaskSettings);
        return new AzureAiStudioEmbeddingsModel(model, taskSettingToUse);
    }

    public AzureAiStudioEmbeddingsModel(String inferenceEntityId, TaskType taskType, String service, AzureAiStudioEmbeddingsServiceSettings serviceSettings, AzureAiStudioEmbeddingsTaskSettings taskSettings, ChunkingSettings chunkingSettings, DefaultSecretSettings secrets) {
        super(new ModelConfigurations(inferenceEntityId, taskType, service, (ServiceSettings)serviceSettings, (TaskSettings)taskSettings, chunkingSettings), new ModelSecrets((SecretSettings)secrets));
    }

    public AzureAiStudioEmbeddingsModel(String inferenceEntityId, TaskType taskType, String service, Map<String, Object> serviceSettings, Map<String, Object> taskSettings, ChunkingSettings chunkingSettings, @Nullable Map<String, Object> secrets, ConfigurationParseContext context) {
        this(inferenceEntityId, taskType, service, AzureAiStudioEmbeddingsServiceSettings.fromMap(serviceSettings, context), AzureAiStudioEmbeddingsTaskSettings.fromMap(taskSettings), chunkingSettings, DefaultSecretSettings.fromMap(secrets));
    }

    private AzureAiStudioEmbeddingsModel(AzureAiStudioEmbeddingsModel model, AzureAiStudioEmbeddingsTaskSettings taskSettings) {
        super(model, taskSettings, model.getServiceSettings().rateLimitSettings());
    }

    public AzureAiStudioEmbeddingsModel(AzureAiStudioEmbeddingsModel model, AzureAiStudioEmbeddingsServiceSettings serviceSettings) {
        super(model, serviceSettings);
    }

    public AzureAiStudioEmbeddingsServiceSettings getServiceSettings() {
        return (AzureAiStudioEmbeddingsServiceSettings)super.getServiceSettings();
    }

    public AzureAiStudioEmbeddingsTaskSettings getTaskSettings() {
        return (AzureAiStudioEmbeddingsTaskSettings)super.getTaskSettings();
    }

    @Override
    protected URI getEndpointUri() throws URISyntaxException {
        if (this.provider == AzureAiStudioProvider.OPENAI || this.endpointType == AzureAiStudioEndpointType.REALTIME) {
            return new URI(this.target);
        }
        return new URI(this.target + "/v1/embeddings");
    }

    @Override
    public ExecutableAction accept(AzureAiStudioActionVisitor creator, Map<String, Object> taskSettings) {
        return creator.create(this, taskSettings);
    }
}

