/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.aggs.changepoint;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.search.aggregations.AggregationReduceContext;
import org.elasticsearch.search.aggregations.AggregatorReducer;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.ml.utils.NamedXContentObject;
import org.elasticsearch.xpack.core.ml.utils.NamedXContentObjectHelper;
import org.elasticsearch.xpack.ml.aggs.changepoint.ChangePointAggregationBuilder;
import org.elasticsearch.xpack.ml.aggs.changepoint.ChangePointBucket;
import org.elasticsearch.xpack.ml.aggs.changepoint.ChangeType;

public class InternalChangePointAggregation
extends InternalAggregation {
    private final ChangePointBucket bucket;
    private final ChangeType changeType;

    public InternalChangePointAggregation(String name, Map<String, Object> metadata, ChangePointBucket bucket, ChangeType changeType) {
        super(name, metadata);
        this.bucket = bucket;
        this.changeType = changeType;
    }

    public InternalChangePointAggregation(StreamInput in) throws IOException {
        super(in);
        this.bucket = in.readBoolean() ? new ChangePointBucket(in) : null;
        this.changeType = (ChangeType)in.readNamedWriteable(ChangeType.class);
    }

    public ChangePointBucket getBucket() {
        return this.bucket;
    }

    public ChangeType getChangeType() {
        return this.changeType;
    }

    public String getWriteableName() {
        return ChangePointAggregationBuilder.NAME.getPreferredName();
    }

    protected void doWriteTo(StreamOutput out) throws IOException {
        if (this.bucket != null) {
            out.writeBoolean(true);
            this.bucket.writeTo(out);
        } else {
            out.writeBoolean(false);
        }
        out.writeNamedWriteable((NamedWriteable)this.changeType);
    }

    protected AggregatorReducer getLeaderReducer(AggregationReduceContext reduceContext, int size) {
        throw new UnsupportedOperationException("Reducing a change_point aggregation is not supported");
    }

    protected boolean mustReduceOnSingleInternalAgg() {
        return false;
    }

    public Object getProperty(List<String> path) {
        if (path.size() == 1) {
            String property = path.get(0);
            if (property.equals("p_value")) {
                return this.changeType.pValue();
            }
            if (property.equals("type")) {
                return this.changeType.getName();
            }
            if (property.equals("change_point")) {
                return this.changeType.changePoint();
            }
        } else if (path.size() > 1 && path.get(0).equals("bucket") && this.bucket != null) {
            return this.bucket.getProperty(this.name, path.subList(1, path.size()));
        }
        return null;
    }

    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.bucket != null) {
            builder.field("bucket", (ToXContent)this.bucket);
        }
        NamedXContentObjectHelper.writeNamedObject((XContentBuilder)builder, (ToXContent.Params)params, (String)"type", (NamedXContentObject)this.changeType);
        return builder;
    }
}

