/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.deprecation;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.common.TriConsumer;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xpack.core.deprecation.DeprecationIssue;
import org.elasticsearch.xpack.core.transform.transforms.TransformConfig;

public class ClusterDeprecationChecker {
    private static final Logger logger = LogManager.getLogger(ClusterDeprecationChecker.class);
    private final List<TriConsumer<ClusterState, List<TransformConfig>, List<DeprecationIssue>>> CHECKS = List.of(this::checkTransformSettings);
    private final NamedXContentRegistry xContentRegistry;

    ClusterDeprecationChecker(NamedXContentRegistry xContentRegistry) {
        this.xContentRegistry = xContentRegistry;
    }

    public List<DeprecationIssue> check(ClusterState clusterState, List<TransformConfig> transformConfigs) {
        ArrayList<DeprecationIssue> allIssues = new ArrayList<DeprecationIssue>();
        this.CHECKS.forEach(check -> check.apply((Object)clusterState, (Object)transformConfigs, (Object)allIssues));
        return allIssues;
    }

    private void checkTransformSettings(ClusterState clusterState, List<TransformConfig> transformConfigs, List<DeprecationIssue> allIssues) {
        for (TransformConfig config : transformConfigs) {
            try {
                allIssues.addAll(config.checkForDeprecations(this.xContentRegistry));
            }
            catch (IOException e) {
                logger.warn("failed to check transformation settings for '" + config.getId() + "'", (Throwable)e);
            }
        }
    }
}

