/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.blobstore.testkit.analyze;

import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.repositories.blobstore.testkit.analyze.RepositoryAnalyzeAction;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.Scope;
import org.elasticsearch.rest.ServerlessScope;
import org.elasticsearch.rest.action.RestCancellableNodeClient;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

@ServerlessScope(value=Scope.INTERNAL)
public class RestRepositoryAnalyzeAction
extends BaseRestHandler {
    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.POST, "/_snapshot/{repository}/_analyze"));
    }

    public String getName() {
        return "repository_analyze";
    }

    public BaseRestHandler.RestChannelConsumer prepareRequest(final RestRequest request, NodeClient client) {
        RepositoryAnalyzeAction.Request analyzeRepositoryRequest = new RepositoryAnalyzeAction.Request(request.param("repository"));
        analyzeRepositoryRequest.blobCount(request.paramAsInt("blob_count", analyzeRepositoryRequest.getBlobCount()));
        analyzeRepositoryRequest.concurrency(request.paramAsInt("concurrency", analyzeRepositoryRequest.getConcurrency()));
        analyzeRepositoryRequest.registerOperationCount(request.paramAsInt("register_operation_count", analyzeRepositoryRequest.getRegisterOperationCount()));
        analyzeRepositoryRequest.readNodeCount(request.paramAsInt("read_node_count", analyzeRepositoryRequest.getReadNodeCount()));
        analyzeRepositoryRequest.earlyReadNodeCount(request.paramAsInt("early_read_node_count", analyzeRepositoryRequest.getEarlyReadNodeCount()));
        analyzeRepositoryRequest.seed(request.paramAsLong("seed", analyzeRepositoryRequest.getSeed()));
        analyzeRepositoryRequest.rareActionProbability(request.paramAsDouble("rare_action_probability", analyzeRepositoryRequest.getRareActionProbability()));
        analyzeRepositoryRequest.maxBlobSize(request.paramAsSize("max_blob_size", analyzeRepositoryRequest.getMaxBlobSize()));
        analyzeRepositoryRequest.maxTotalDataSize(request.paramAsSize("max_total_data_size", analyzeRepositoryRequest.getMaxTotalDataSize()));
        analyzeRepositoryRequest.timeout(request.paramAsTime("timeout", analyzeRepositoryRequest.getTimeout()));
        analyzeRepositoryRequest.detailed(request.paramAsBoolean("detailed", analyzeRepositoryRequest.getDetailed()));
        analyzeRepositoryRequest.abortWritePermitted(request.paramAsBoolean("rarely_abort_writes", analyzeRepositoryRequest.isAbortWritePermitted()));
        RestCancellableNodeClient cancelClient = new RestCancellableNodeClient(client, request.getHttpChannel());
        return channel -> cancelClient.execute(RepositoryAnalyzeAction.INSTANCE, (ActionRequest)analyzeRepositoryRequest, (ActionListener)new RestToXContentListener<RepositoryAnalyzeAction.Response>(channel){

            public RestResponse buildResponse(RepositoryAnalyzeAction.Response response, XContentBuilder builder) throws Exception {
                builder.humanReadable(request.paramAsBoolean("human", true));
                return super.buildResponse((ToXContentObject)response, builder);
            }
        });
    }
}

