/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ilm;

import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.LongSupplier;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.NotMasterException;
import org.elasticsearch.cluster.coordination.FailedToCommitClusterStateException;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.LifecycleExecutionState;
import org.elasticsearch.common.Strings;
import org.elasticsearch.index.Index;
import org.elasticsearch.xpack.core.ilm.Step;
import org.elasticsearch.xpack.ilm.IndexLifecycleClusterStateUpdateTask;
import org.elasticsearch.xpack.ilm.IndexLifecycleTransition;

public class MoveToErrorStepUpdateTask
extends IndexLifecycleClusterStateUpdateTask {
    private static final Logger logger = LogManager.getLogger(MoveToErrorStepUpdateTask.class);
    private final Index index;
    private final String policy;
    private final Step.StepKey currentStepKey;
    private final BiFunction<IndexMetadata, Step.StepKey, Step> stepLookupFunction;
    private final Consumer<ClusterState> stateChangeConsumer;
    private final LongSupplier nowSupplier;
    private final Exception cause;

    public MoveToErrorStepUpdateTask(Index index, String policy, Step.StepKey currentStepKey, Exception cause, LongSupplier nowSupplier, BiFunction<IndexMetadata, Step.StepKey, Step> stepLookupFunction, Consumer<ClusterState> stateChangeConsumer) {
        super(index, currentStepKey);
        this.index = index;
        this.policy = policy;
        this.currentStepKey = currentStepKey;
        this.cause = cause;
        this.nowSupplier = nowSupplier;
        this.stepLookupFunction = stepLookupFunction;
        this.stateChangeConsumer = stateChangeConsumer;
    }

    @Override
    protected ClusterState doExecute(ClusterState currentState) throws Exception {
        IndexMetadata idxMeta = currentState.getMetadata().index(this.index);
        if (idxMeta == null) {
            return currentState;
        }
        LifecycleExecutionState lifecycleState = idxMeta.getLifecycleExecutionState();
        if (this.policy.equals(idxMeta.getLifecyclePolicyName()) && this.currentStepKey.equals((Object)Step.getCurrentStepKey((LifecycleExecutionState)lifecycleState))) {
            return IndexLifecycleTransition.moveClusterStateToErrorStep(this.index, currentState, this.cause, this.nowSupplier, this.stepLookupFunction);
        }
        return currentState;
    }

    @Override
    public void onClusterStateProcessed(ClusterState newState) {
        this.stateChangeConsumer.accept(newState);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MoveToErrorStepUpdateTask that = (MoveToErrorStepUpdateTask)o;
        return this.index.equals((Object)that.index) && this.policy.equals(that.policy) && this.currentStepKey.equals((Object)that.currentStepKey);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.index, this.policy, this.currentStepKey);
    }

    @Override
    protected void handleFailure(Exception e) {
        Level level;
        if (ExceptionsHelper.unwrap((Throwable)e, (Class[])new Class[]{NotMasterException.class, FailedToCommitClusterStateException.class}) != null) {
            level = Level.DEBUG;
        } else {
            level = Level.ERROR;
            assert (false) : new AssertionError("unexpected exception", e);
        }
        logger.log(level, () -> Strings.format((String)"policy [%s] for index [%s] failed trying to move from step [%s] to the ERROR step.", (Object[])new Object[]{this.policy, this.index.getName(), this.currentStepKey}));
    }
}

