/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.lucene.bwc.codecs;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.lucene.codecs.FieldsConsumer;
import org.apache.lucene.codecs.FieldsProducer;
import org.apache.lucene.codecs.PostingsFormat;
import org.apache.lucene.codecs.perfield.PerFieldPostingsFormat;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.Terms;
import org.elasticsearch.core.IOUtils;
import org.elasticsearch.xpack.lucene.bwc.codecs.BWCCodec;
import org.elasticsearch.xpack.lucene.bwc.codecs.lucene50.BWCLucene50PostingsFormat;

public final class LegacyAdaptingPerFieldPostingsFormat
extends PostingsFormat {
    public static final String PER_FIELD_NAME = "PerField40";
    public static final String PER_FIELD_FORMAT_KEY = PerFieldPostingsFormat.class.getSimpleName() + ".format";
    public static final String PER_FIELD_SUFFIX_KEY = PerFieldPostingsFormat.class.getSimpleName() + ".suffix";

    public LegacyAdaptingPerFieldPostingsFormat() {
        super(PER_FIELD_NAME);
    }

    static String getSuffix(String formatName, String suffix) {
        return formatName + "_" + suffix;
    }

    private static PostingsFormat getPostingsFormat(String formatName) {
        if (formatName.equals("Lucene50")) {
            return new BWCLucene50PostingsFormat();
        }
        return new BWCCodec.EmptyPostingsFormat();
    }

    public FieldsConsumer fieldsConsumer(SegmentWriteState state) {
        throw new IllegalStateException("This codec should only be used for reading, not writing");
    }

    public FieldsProducer fieldsProducer(SegmentReadState state) throws IOException {
        return new FieldsReader(state);
    }

    private static class FieldsReader
    extends FieldsProducer {
        private final Map<String, FieldsProducer> fields = new TreeMap<String, FieldsProducer>();
        private final Map<String, FieldsProducer> formats = new HashMap<String, FieldsProducer>();
        private final String segment;

        FieldsReader(FieldsReader other) {
            IdentityHashMap<FieldsProducer, FieldsProducer> oldToNew = new IdentityHashMap<FieldsProducer, FieldsProducer>();
            for (Map.Entry<String, FieldsProducer> ent : other.formats.entrySet()) {
                FieldsProducer values = ent.getValue().getMergeInstance();
                this.formats.put(ent.getKey(), values);
                oldToNew.put(ent.getValue(), values);
            }
            for (Map.Entry<String, FieldsProducer> ent : other.fields.entrySet()) {
                FieldsProducer producer = (FieldsProducer)oldToNew.get(ent.getValue());
                assert (producer != null);
                this.fields.put(ent.getKey(), producer);
            }
            this.segment = other.segment;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        FieldsReader(SegmentReadState readState) throws IOException {
            boolean success = false;
            try {
                for (FieldInfo fi : readState.fieldInfos) {
                    if (fi.getIndexOptions() == IndexOptions.NONE) continue;
                    String fieldName = fi.name;
                    String formatName = fi.getAttribute(PER_FIELD_FORMAT_KEY);
                    if (formatName == null) continue;
                    String suffix = fi.getAttribute(PER_FIELD_SUFFIX_KEY);
                    if (suffix == null) {
                        throw new IllegalStateException("missing attribute: " + PER_FIELD_SUFFIX_KEY + " for field: " + fieldName);
                    }
                    PostingsFormat format = LegacyAdaptingPerFieldPostingsFormat.getPostingsFormat(formatName);
                    String segmentSuffix = LegacyAdaptingPerFieldPostingsFormat.getSuffix(formatName, suffix);
                    if (!this.formats.containsKey(segmentSuffix)) {
                        this.formats.put(segmentSuffix, format.fieldsProducer(new SegmentReadState(readState, segmentSuffix)));
                    }
                    this.fields.put(fieldName, this.formats.get(segmentSuffix));
                }
                success = true;
            }
            finally {
                if (!success) {
                    IOUtils.closeWhileHandlingException(this.formats.values());
                }
            }
            this.segment = readState.segmentInfo.name;
        }

        public Iterator<String> iterator() {
            return Collections.unmodifiableSet(this.fields.keySet()).iterator();
        }

        public Terms terms(String field) throws IOException {
            FieldsProducer fieldsProducer = this.fields.get(field);
            return fieldsProducer == null ? null : fieldsProducer.terms(field);
        }

        public int size() {
            return this.fields.size();
        }

        public void close() throws IOException {
            IOUtils.close(this.formats.values());
        }

        public void checkIntegrity() throws IOException {
            for (FieldsProducer producer : this.formats.values()) {
                producer.checkIntegrity();
            }
        }

        public FieldsProducer getMergeInstance() {
            return new FieldsReader(this);
        }

        public String toString() {
            return "PerFieldPostings(segment=" + this.segment + " formats=" + this.formats.size() + ")";
        }
    }
}

