/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.impl.sql.compile.DDLStatementNode;
import org.apache.derby.shared.common.error.StandardException;

class CreateSchemaNode
extends DDLStatementNode {
    private String name;
    private String aid;

    CreateSchemaNode(String schemaName, String aid, ContextManager cm) throws StandardException {
        super(null, cm);
        this.name = schemaName;
        this.aid = aid;
    }

    @Override
    public String toString() {
        return super.toString() + "schemaName: \n" + this.name + "\nauthorizationId: \n" + this.aid + "\n";
    }

    @Override
    public void bindStatement() throws StandardException {
        CompilerContext cc = this.getCompilerContext();
        if (this.isPrivilegeCollectionRequired()) {
            cc.addRequiredSchemaPriv(this.name, this.aid, 16);
        }
    }

    @Override
    String statementToString() {
        return "CREATE SCHEMA";
    }

    @Override
    public ConstantAction makeConstantAction() {
        return this.getGenericConstantActionFactory().getCreateSchemaConstantAction(this.name, this.aid);
    }
}

