/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.action.service;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.rest.action.RestActions;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.security.action.service.GetServiceAccountCredentialsNodesResponse;
import org.elasticsearch.xpack.core.security.action.service.TokenInfo;

public class GetServiceAccountCredentialsResponse
extends ActionResponse
implements ToXContentObject {
    private final String principal;
    private final List<TokenInfo> indexTokenInfos;
    private final GetServiceAccountCredentialsNodesResponse nodesResponse;

    public GetServiceAccountCredentialsResponse(String principal, Collection<TokenInfo> indexTokenInfos, GetServiceAccountCredentialsNodesResponse nodesResponse) {
        this.principal = principal;
        this.indexTokenInfos = indexTokenInfos == null ? List.of() : indexTokenInfos.stream().sorted().toList();
        this.nodesResponse = nodesResponse;
    }

    public GetServiceAccountCredentialsResponse(StreamInput in) throws IOException {
        super(in);
        this.principal = in.readString();
        this.indexTokenInfos = in.readCollectionAsList(TokenInfo::new);
        this.nodesResponse = new GetServiceAccountCredentialsNodesResponse(in);
    }

    public String getPrincipal() {
        return this.principal;
    }

    public List<TokenInfo> getIndexTokenInfos() {
        return this.indexTokenInfos;
    }

    public GetServiceAccountCredentialsNodesResponse getNodesResponse() {
        return this.nodesResponse;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.principal);
        out.writeCollection(this.indexTokenInfos);
        this.nodesResponse.writeTo(out);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        List<TokenInfo> fileTokenInfos = this.nodesResponse.getFileTokenInfos();
        builder.startObject().field("service_account", this.principal).field("count", this.indexTokenInfos.size() + fileTokenInfos.size()).field("tokens").startObject();
        for (TokenInfo info : this.indexTokenInfos) {
            info.toXContent(builder, params);
        }
        builder.endObject().field("nodes_credentials").startObject();
        RestActions.buildNodesHeader(builder, params, this.nodesResponse);
        builder.startObject("file_tokens");
        for (TokenInfo info : fileTokenInfos) {
            info.toXContent(builder, params);
        }
        builder.endObject();
        builder.endObject().endObject();
        return builder;
    }

    public String toString() {
        return "GetServiceAccountCredentialsResponse{principal='" + this.principal + "', indexTokenInfos=" + String.valueOf(this.indexTokenInfos) + ", nodesResponse=" + String.valueOf(this.nodesResponse) + "}";
    }
}

