/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.monitoring.action;

import java.io.IOException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum MonitoringIndex implements Writeable
{
    IGNORED_DATA{

        @Override
        public boolean matchesIndexName(String indexName) {
            return false;
        }
    }
    ,
    TIMESTAMPED{

        @Override
        public boolean matchesIndexName(String indexName) {
            return Strings.isEmpty(indexName);
        }
    };


    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeByte((byte)this.ordinal());
    }

    public static MonitoringIndex readFrom(StreamInput in) throws IOException {
        return MonitoringIndex.values()[in.readByte()];
    }

    public abstract boolean matchesIndexName(String var1);

    public static MonitoringIndex from(String indexName) {
        if (TIMESTAMPED.matchesIndexName(indexName)) {
            return TIMESTAMPED;
        }
        if ("_data".equals(indexName)) {
            return IGNORED_DATA;
        }
        throw new IllegalArgumentException("unrecognized index name [" + indexName + "]");
    }
}

