/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.enrich.action;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.tasks.TaskInfo;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class EnrichStatsAction
extends ActionType<Response> {
    public static final EnrichStatsAction INSTANCE = new EnrichStatsAction();
    public static final String NAME = "cluster:monitor/xpack/enrich/stats";

    private EnrichStatsAction() {
        super(NAME);
    }

    public static class Response
    extends ActionResponse
    implements ToXContentObject {
        private final List<ExecutingPolicy> executingPolicies;
        private final List<CoordinatorStats> coordinatorStats;
        private final List<CacheStats> cacheStats;

        public Response(List<ExecutingPolicy> executingPolicies, List<CoordinatorStats> coordinatorStats, List<CacheStats> cacheStats) {
            this.executingPolicies = executingPolicies;
            this.coordinatorStats = coordinatorStats;
            this.cacheStats = cacheStats;
        }

        public Response(StreamInput in) throws IOException {
            super(in);
            this.executingPolicies = in.readCollectionAsList(ExecutingPolicy::new);
            this.coordinatorStats = in.readCollectionAsList(CoordinatorStats::new);
            this.cacheStats = in.readCollectionAsList(CacheStats::new);
        }

        public List<ExecutingPolicy> getExecutingPolicies() {
            return this.executingPolicies;
        }

        public List<CoordinatorStats> getCoordinatorStats() {
            return this.coordinatorStats;
        }

        public List<CacheStats> getCacheStats() {
            return this.cacheStats;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeCollection(this.executingPolicies);
            out.writeCollection(this.coordinatorStats);
            out.writeCollection(this.cacheStats);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.startArray("executing_policies");
            for (ExecutingPolicy policy : this.executingPolicies) {
                builder.startObject();
                policy.toXContent(builder, params);
                builder.endObject();
            }
            builder.endArray();
            builder.startArray("coordinator_stats");
            for (CoordinatorStats entry : this.coordinatorStats) {
                builder.startObject();
                entry.toXContent(builder, params);
                builder.endObject();
            }
            builder.endArray();
            if (this.cacheStats != null) {
                builder.startArray("cache_stats");
                for (CacheStats cacheStat : this.cacheStats) {
                    builder.startObject();
                    cacheStat.toXContent(builder, params);
                    builder.endObject();
                }
                builder.endArray();
            }
            builder.endObject();
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Response response = (Response)o;
            return this.executingPolicies.equals(response.executingPolicies) && this.coordinatorStats.equals(response.coordinatorStats) && Objects.equals(this.cacheStats, response.cacheStats);
        }

        public int hashCode() {
            return Objects.hash(this.executingPolicies, this.coordinatorStats, this.cacheStats);
        }

        public record ExecutingPolicy(String name, TaskInfo taskInfo) implements Writeable,
        ToXContentFragment
        {
            ExecutingPolicy(StreamInput in) throws IOException {
                this(in.readString(), TaskInfo.from(in));
            }

            @Override
            public void writeTo(StreamOutput out) throws IOException {
                out.writeString(this.name);
                this.taskInfo.writeTo(out);
            }

            @Override
            public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
                builder.field("name", this.name);
                builder.startObject("task");
                builder.value(this.taskInfo);
                builder.endObject();
                return builder;
            }
        }

        public record CoordinatorStats(String nodeId, int queueSize, int remoteRequestsCurrent, long remoteRequestsTotal, long executedSearchesTotal) implements Writeable,
        ToXContentFragment
        {
            public CoordinatorStats(StreamInput in) throws IOException {
                this(in.readString(), in.readVInt(), in.readVInt(), in.readVLong(), in.readVLong());
            }

            @Override
            public void writeTo(StreamOutput out) throws IOException {
                out.writeString(this.nodeId);
                out.writeVInt(this.queueSize);
                out.writeVInt(this.remoteRequestsCurrent);
                out.writeVLong(this.remoteRequestsTotal);
                out.writeVLong(this.executedSearchesTotal);
            }

            @Override
            public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
                builder.field("node_id", this.nodeId);
                builder.field("queue_size", this.queueSize);
                builder.field("remote_requests_current", this.remoteRequestsCurrent);
                builder.field("remote_requests_total", this.remoteRequestsTotal);
                builder.field("executed_searches_total", this.executedSearchesTotal);
                return builder;
            }
        }

        public record CacheStats(String nodeId, long count, long hits, long misses, long evictions, long hitsTimeInMillis, long missesTimeInMillis, long cacheSizeInBytes) implements Writeable,
        ToXContentFragment
        {
            public CacheStats(StreamInput in) throws IOException {
                this(in.readString(), in.readVLong(), in.readVLong(), in.readVLong(), in.readVLong(), in.getTransportVersion().onOrAfter(TransportVersions.V_8_15_0) ? in.readLong() : -1L, in.getTransportVersion().onOrAfter(TransportVersions.V_8_15_0) ? in.readLong() : -1L, in.getTransportVersion().onOrAfter(TransportVersions.V_8_16_0) ? in.readLong() : -1L);
            }

            @Override
            public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
                builder.field("node_id", this.nodeId);
                builder.field("count", this.count);
                builder.field("hits", this.hits);
                builder.field("misses", this.misses);
                builder.field("evictions", this.evictions);
                builder.humanReadableField("hits_time_in_millis", "hits_time", new TimeValue(this.hitsTimeInMillis));
                builder.humanReadableField("misses_time_in_millis", "misses_time", new TimeValue(this.missesTimeInMillis));
                builder.humanReadableField("size_in_bytes", "size", ByteSizeValue.ofBytes(this.cacheSizeInBytes));
                return builder;
            }

            @Override
            public void writeTo(StreamOutput out) throws IOException {
                out.writeString(this.nodeId);
                out.writeVLong(this.count);
                out.writeVLong(this.hits);
                out.writeVLong(this.misses);
                out.writeVLong(this.evictions);
                if (out.getTransportVersion().onOrAfter(TransportVersions.V_8_15_0)) {
                    out.writeLong(this.hitsTimeInMillis);
                    out.writeLong(this.missesTimeInMillis);
                }
                if (out.getTransportVersion().onOrAfter(TransportVersions.V_8_16_0)) {
                    out.writeLong(this.cacheSizeInBytes);
                }
            }
        }
    }

    public static class Request
    extends MasterNodeRequest<Request> {
        public Request(TimeValue masterNodeTimeout) {
            super(masterNodeTimeout);
        }

        public Request(StreamInput in) throws IOException {
            super(in);
        }

        @Override
        public ActionRequestValidationException validate() {
            return null;
        }
    }
}

