/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.nested;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.join.BitSetProducer;
import org.apache.lucene.util.BitSet;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.common.util.LongArray;
import org.elasticsearch.index.mapper.NestedObjectMapper;
import org.elasticsearch.search.aggregations.AggregationExecutionContext;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.CardinalityUpperBound;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.LeafBucketCollectorBase;
import org.elasticsearch.search.aggregations.bucket.BucketsAggregator;
import org.elasticsearch.search.aggregations.bucket.SingleBucketAggregator;
import org.elasticsearch.search.aggregations.bucket.nested.InternalReverseNested;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.xcontent.ParseField;

public class ReverseNestedAggregator
extends BucketsAggregator
implements SingleBucketAggregator {
    static final ParseField PATH_FIELD = new ParseField("path", new String[0]);
    private final BitSetProducer parentBitsetProducer;

    public ReverseNestedAggregator(String name, AggregatorFactories factories, NestedObjectMapper objectMapper, AggregationContext context, Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        super(name, factories, context, parent, cardinality, metadata);
        Query parentFilter = objectMapper == null ? Queries.newNonNestedFilter(context.getIndexSettings().getIndexVersionCreated()) : objectMapper.nestedTypeFilter();
        this.parentBitsetProducer = context.bitsetFilterCache().getBitSetProducer(parentFilter);
    }

    @Override
    protected LeafBucketCollector getLeafCollector(AggregationExecutionContext aggCtx, final LeafBucketCollector sub) throws IOException {
        final BitSet parentDocs = this.parentBitsetProducer.getBitSet(aggCtx.getLeafReaderContext());
        if (parentDocs == null) {
            return LeafBucketCollector.NO_OP_COLLECTOR;
        }
        final HashMap bucketOrdToLastCollectedParentDoc = new HashMap(32);
        return new LeafBucketCollectorBase(sub, null){

            @Override
            public void collect(int childDoc, long bucket) throws IOException {
                int parentDoc = parentDocs.nextSetBit(childDoc);
                assert (childDoc <= parentDoc && parentDoc != Integer.MAX_VALUE);
                Integer lastCollectedParentDoc = (Integer)bucketOrdToLastCollectedParentDoc.get(bucket);
                if (lastCollectedParentDoc != null) {
                    if (parentDoc > lastCollectedParentDoc) {
                        ReverseNestedAggregator.this.collectBucket(sub, parentDoc, bucket);
                        bucketOrdToLastCollectedParentDoc.put(bucket, parentDoc);
                    }
                } else {
                    ReverseNestedAggregator.this.collectBucket(sub, parentDoc, bucket);
                    bucketOrdToLastCollectedParentDoc.put(bucket, parentDoc);
                }
            }
        };
    }

    @Override
    public InternalAggregation[] buildAggregations(LongArray owningBucketOrds) throws IOException {
        return this.buildAggregationsForSingleBucket(owningBucketOrds, (owningBucketOrd, subAggregationResults) -> new InternalReverseNested(this.name, this.bucketDocCount(owningBucketOrd), subAggregationResults, this.metadata()));
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        return new InternalReverseNested(this.name, 0L, this.buildEmptySubAggregations(), this.metadata());
    }
}

