/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.injection.guice;

import java.util.List;
import org.elasticsearch.injection.guice.InjectorImpl;
import org.elasticsearch.injection.guice.MembersInjector;
import org.elasticsearch.injection.guice.SingleMethodInjector;
import org.elasticsearch.injection.guice.TypeLiteral;
import org.elasticsearch.injection.guice.internal.Errors;
import org.elasticsearch.injection.guice.internal.ErrorsException;
import org.elasticsearch.injection.guice.internal.InternalContext;

class MembersInjectorImpl<T>
implements MembersInjector<T> {
    private final TypeLiteral<T> typeLiteral;
    private final InjectorImpl injector;
    private final List<SingleMethodInjector> memberInjectors;

    MembersInjectorImpl(InjectorImpl injector, TypeLiteral<T> typeLiteral, List<SingleMethodInjector> memberInjectors) {
        this.injector = injector;
        this.typeLiteral = typeLiteral;
        this.memberInjectors = memberInjectors;
    }

    void injectAndNotify(T instance, Errors errors) throws ErrorsException {
        if (instance == null) {
            return;
        }
        this.injector.callInContext(context -> {
            this.injectMembers(instance, errors, context);
            return null;
        });
    }

    void injectMembers(T t, Errors errors, InternalContext context) {
        int size = this.memberInjectors.size();
        for (int i = 0; i < size; ++i) {
            this.memberInjectors.get(i).inject(errors, context, t);
        }
    }

    public String toString() {
        return "MembersInjector<" + String.valueOf(this.typeLiteral) + ">";
    }
}

