/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.stats;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class SynonymsStats
implements ToXContentObject,
Writeable {
    int count;
    int indexCount;

    SynonymsStats() {
    }

    SynonymsStats(StreamInput in) throws IOException {
        this.count = in.readVInt();
        this.indexCount = in.readVInt();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.count);
        out.writeVInt(this.indexCount);
    }

    public int getCount() {
        return this.count;
    }

    public int getIndexCount() {
        return this.indexCount;
    }

    public boolean equals(Object other) {
        if (!(other instanceof SynonymsStats)) {
            return false;
        }
        SynonymsStats that = (SynonymsStats)other;
        return this.count == that.count && this.indexCount == that.indexCount;
    }

    public int hashCode() {
        return Objects.hash(this.count, this.indexCount);
    }

    @Override
    public final XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("count", this.count);
        builder.field("index_count", this.indexCount);
        this.doXContent(builder, params);
        builder.endObject();
        return builder;
    }

    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
    }

    public String toString() {
        return "SynonymsStats{count=" + this.count + ", indexCount=" + this.indexCount + "}";
    }
}

