/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.logstash.filters.elasticintegration.util;

import co.elastic.logstash.api.Password;
import co.elastic.logstash.filters.elasticintegration.util.Exceptions;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Base64;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.crypto.Cipher;
import javax.crypto.EncryptedPrivateKeyInfo;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;

public class KeyStoreUtil {
    static final Pattern PRIVATE_KEY_PATTERN = Pattern.compile("-+BEGIN\\s+.*PRIVATE\\s+KEY[^-]*-+(?:\\s|\\r|\\n)+([a-z0-9+/=\\r\\n]+)-+END\\s+.*PRIVATE\\s+KEY[^-]*-+", 2);

    private KeyStoreUtil() {
    }

    private static String guessKeystoreType(Path path) {
        String filename = path.getFileName().toString();
        if (filename.endsWith(".jks")) {
            return "jks";
        }
        if (filename.endsWith(".p12")) {
            return "pkcs12";
        }
        return KeyStore.getDefaultType();
    }

    public static KeyStore load(Path keyStorePath, Password keyStorePassword) {
        try {
            String keystoreType = KeyStoreUtil.guessKeystoreType(keyStorePath);
            KeyStore keyStore = KeyStore.getInstance(keystoreType);
            keyStore.load(Files.newInputStream(keyStorePath, new OpenOption[0]), keyStorePassword.getPassword().toCharArray());
            return keyStore;
        }
        catch (Exception e) {
            throw Exceptions.wrap(e, String.format("Failed to load keystore from `%s`", keyStorePath));
        }
    }

    public static KeyStore fromCertificateAuthorities(List<Path> certAuthoritiesPaths) {
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load(() -> new KeyStore.PasswordProtection("test".toCharArray()));
            for (Path certAuthorityPath : certAuthoritiesPaths) {
                try {
                    InputStream in = Files.newInputStream(certAuthorityPath, new OpenOption[0]);
                    try {
                        List certChains = (List)certificateFactory.generateCertificates(in);
                        for (X509Certificate trustedCert : certChains) {
                            keyStore.setCertificateEntry(trustedCert.getSubjectX500Principal().getName(), trustedCert);
                        }
                    }
                    finally {
                        if (in == null) continue;
                        in.close();
                    }
                }
                catch (Exception e) {
                    throw Exceptions.wrap(e, String.format("Failed to extract certificates from `%s`", certAuthorityPath));
                }
            }
            return keyStore;
        }
        catch (Exception e) {
            throw Exceptions.wrap(e, String.format("Failed to build keystore from certificate authorities `%s`", certAuthoritiesPaths));
        }
    }

    public static KeyStore fromCertKeyPair(Path cert, Path key, Password keyPassword) {
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            PKCS8EncodedKeySpec keySpec = KeyStoreUtil.readPrivateKey(key, keyPassword);
            PrivateKey privateKey = keyFactory.generatePrivate(keySpec);
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load(() -> new KeyStore.PasswordProtection(keyPassword.getPassword().toCharArray()));
            try (InputStream in = Files.newInputStream(cert, new OpenOption[0]);){
                List certChain = (List)certificateFactory.generateCertificates(in);
                keyStore.setKeyEntry("key", privateKey, keyPassword.getPassword().toCharArray(), certChain.toArray(new Certificate[0]));
            }
            return keyStore;
        }
        catch (Exception e) {
            throw Exceptions.wrap(e, String.format("Failed to build keystore from certificate/key pair `%s`/`%s`", cert, key));
        }
    }

    private static PKCS8EncodedKeySpec readPrivateKey(Path key, Password password) throws Exception {
        String rawKey = Files.readString(key, StandardCharsets.US_ASCII);
        Matcher matcher = PRIVATE_KEY_PATTERN.matcher(rawKey);
        if (!matcher.find()) {
            throw new KeyStoreException(String.format("found no PEM-encoded private key in file: %s", key));
        }
        byte[] encodedKey = Base64.getMimeDecoder().decode(matcher.group(1));
        if (password == null) {
            return new PKCS8EncodedKeySpec(encodedKey);
        }
        try {
            EncryptedPrivateKeyInfo encryptedPrivateKeyInfo = new EncryptedPrivateKeyInfo(encodedKey);
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(encryptedPrivateKeyInfo.getAlgName());
            SecretKey secretKey = keyFactory.generateSecret(new PBEKeySpec(password.getPassword().toCharArray()));
            Cipher cipher = Cipher.getInstance(encryptedPrivateKeyInfo.getAlgName());
            cipher.init(2, (Key)secretKey, encryptedPrivateKeyInfo.getAlgParameters());
            return encryptedPrivateKeyInfo.getKeySpec(cipher);
        }
        catch (Exception e) {
            throw Exceptions.wrap(e, String.format("failed to import possibly-encrypted PKCS8-encoded key from file: %s", key));
        }
    }
}

