/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.watcher.transport.actions.put;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.TimeValue;

public class UpdateWatcherSettingsAction
extends ActionType<AcknowledgedResponse> {
    public static final UpdateWatcherSettingsAction INSTANCE = new UpdateWatcherSettingsAction();
    public static final String NAME = "cluster:admin/xpack/watcher/settings/update";
    public static final Set<String> ALLOWED_SETTING_KEYS = Set.of("index.number_of_replicas", "index.auto_expand_replicas");
    public static final Set<String> ALLOWED_SETTINGS_PREFIXES = Set.of("index.routing.allocation.exclude", "index.routing.allocation.include", "index.routing.allocation.require");
    public static final Set<String> EXPLICITLY_DENIED_SETTINGS = Set.of("index.routing.allocation.include._tier_preference");

    public UpdateWatcherSettingsAction() {
        super(NAME);
    }

    public static class Request
    extends AcknowledgedRequest<Request> {
        private final Map<String, Object> settings;

        public Request(TimeValue masterNodeTimeout, TimeValue ackTimeout, Map<String, Object> settings) {
            super(masterNodeTimeout, ackTimeout);
            this.settings = settings;
        }

        public static Request readFrom(StreamInput in) throws IOException {
            if (in.getTransportVersion().onOrAfter(TransportVersions.V_8_15_0)) {
                return new Request(in);
            }
            return new Request(TimeValue.THIRTY_SECONDS, TimeValue.THIRTY_SECONDS, in);
        }

        private Request(StreamInput in) throws IOException {
            super(in);
            this.settings = in.readGenericMap();
        }

        private Request(TimeValue masterNodeTimeout, TimeValue ackTimeout, StreamInput in) throws IOException {
            super(masterNodeTimeout, ackTimeout);
            this.settings = in.readGenericMap();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            if (out.getTransportVersion().onOrAfter(TransportVersions.V_8_15_0)) {
                super.writeTo(out);
            }
            out.writeGenericMap(this.settings);
        }

        public Map<String, Object> settings() {
            return this.settings;
        }

        @Override
        public ActionRequestValidationException validate() {
            Set forbiddenSettings = this.settings.keySet().stream().filter(setting -> !ALLOWED_SETTING_KEYS.contains(setting) && ALLOWED_SETTINGS_PREFIXES.stream().noneMatch(prefix -> setting.startsWith(prefix + ".")) || EXPLICITLY_DENIED_SETTINGS.contains(setting)).collect(Collectors.toSet());
            if (!forbiddenSettings.isEmpty()) {
                return ValidateActions.addValidationError("illegal settings: " + String.valueOf(forbiddenSettings) + ", these settings may not be configured. Only the following settings may be configured: " + String.valueOf(ALLOWED_SETTING_KEYS) + ", " + String.valueOf(ALLOWED_SETTINGS_PREFIXES.stream().map(s -> s + ".*").collect(Collectors.toSet())) + " excluding the following explicitly denied settings: " + String.valueOf(EXPLICITLY_DENIED_SETTINGS), null);
            }
            return null;
        }
    }
}

