/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.action;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.support.nodes.BaseNodeResponse;
import org.elasticsearch.action.support.nodes.BaseNodesRequest;
import org.elasticsearch.action.support.nodes.BaseNodesResponse;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.unit.ByteSizeValue;

public class TrainedModelCacheInfoAction
extends ActionType<Response> {
    public static final TrainedModelCacheInfoAction INSTANCE = new TrainedModelCacheInfoAction();
    public static final String NAME = "cluster:internal/xpack/ml/trained_models/cache/info";

    private TrainedModelCacheInfoAction() {
        super(NAME);
    }

    public static class Response
    extends BaseNodesResponse<CacheInfo> {
        public Response(StreamInput in) throws IOException {
            super(in);
        }

        public Response(ClusterName clusterName, List<CacheInfo> nodes, List<FailedNodeException> failures) {
            super(clusterName, nodes, failures);
        }

        @Override
        protected List<CacheInfo> readNodesFrom(StreamInput in) throws IOException {
            return in.readCollectionAsList(CacheInfo::new);
        }

        @Override
        protected void writeNodesTo(StreamOutput out, List<CacheInfo> nodes) throws IOException {
            out.writeCollection(nodes);
        }

        public int hashCode() {
            return Objects.hash(this.getNodes());
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Response other = (Response)obj;
            return Objects.equals(this.getNodes(), other.getNodes());
        }

        public static class CacheInfo
        extends BaseNodeResponse
        implements Writeable {
            private final ByteSizeValue jvmInferenceMax;
            private final ByteSizeValue jvmInference;

            public CacheInfo(DiscoveryNode node, ByteSizeValue jvmInferenceMax, ByteSizeValue jvmInference) {
                super(node);
                this.jvmInferenceMax = Objects.requireNonNull(jvmInferenceMax);
                this.jvmInference = Objects.requireNonNull(jvmInference);
            }

            public CacheInfo(StreamInput in) throws IOException {
                super(in);
                this.jvmInferenceMax = ByteSizeValue.readFrom(in);
                this.jvmInference = ByteSizeValue.readFrom(in);
            }

            public ByteSizeValue getJvmInferenceMax() {
                return this.jvmInferenceMax;
            }

            public ByteSizeValue getJvmInference() {
                return this.jvmInference;
            }

            @Override
            public void writeTo(StreamOutput out) throws IOException {
                super.writeTo(out);
                this.jvmInferenceMax.writeTo(out);
                this.jvmInference.writeTo(out);
            }

            public int hashCode() {
                return Objects.hash(this.getNode(), this.jvmInferenceMax, this.jvmInference);
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                CacheInfo cacheInfo = (CacheInfo)o;
                return Objects.equals(this.getNode(), cacheInfo.getNode()) && Objects.equals(this.jvmInferenceMax, cacheInfo.jvmInferenceMax) && Objects.equals(this.jvmInference, cacheInfo.jvmInference);
            }
        }
    }

    public static class Request
    extends BaseNodesRequest<Request> {
        private final DiscoveryNode[] concreteNodes;

        public Request(DiscoveryNode ... concreteNodes) {
            super(concreteNodes);
            this.concreteNodes = concreteNodes;
        }

        public int hashCode() {
            return Arrays.hashCode(this.concreteNodes);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Request other = (Request)obj;
            return Arrays.deepEquals(this.concreteNodes, other.concreteNodes);
        }
    }
}

